<?php
/**
* Support Helper Files
*/

//exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


if( ! class_exists( 'HT_KnowAll_Support_Helpers' ) ){

	class HT_KnowAll_Support_Helpers{

		//constructor 
		function __construct(){
			//hooks
			add_action( 'admin_notices', array( $this, 'ht_knowall_activation_reminder' ), 10 );
			//access check filter, plugins at 20-30, themes at 30-40

			//this function has been replaced by the ht-kb-analytics-pro plugin
       		//add_action( 'ht_analytics_functions', array( $this,  'ht_knowall_check_analytics_functions_access' ), 30 );
		}

		function ht_knowall_activation_reminder(){
			$screen = get_current_screen();
			$theme_license_status = get_option( 'knowall_license_key_status', false );
			$hide_knowall_activation_reminder = apply_filters( 'hide_knowall_activation_reminder', false );
			if( is_a($screen, 'WP_Screen') && 'appearance_page_knowall-license' != $screen->id && 'appearance_page_knowall-welcome' != $screen->id && 'valid' != $theme_license_status && !$hide_knowall_activation_reminder ):
			    ?>
			    <div class="notice notice-info is-dismissible">
			        <p>
			        	<?php esc_html_e( 'Your KnowAll key is not activated, you could be missing important updates and support.', 'knowall' ); ?> 
			        	<a href="<?php echo esc_url( admin_url( 'themes.php?page=knowall-license' ) ); ?>"><?php esc_html_e( 'Activate Now', 'knowall' ); ?></a>		        	
			        </p>
			    </div>
			    <?php
			endif;
		}

		//access check for analytics
		//deprecated - use ht-kb-analytics-pro plugin instead
	    function ht_knowall_check_analytics_functions_access($allow){
	    	$knowall_license_price_id = trim( get_option( 'knowall_license_price_id', '' ) );

	        if( empty( $knowall_license_price_id ) ){
	            //no knowall price id, no access
	            $allow = false;
	        } else {
	            //allow_all
	            $allow = true;

	            //explicit disallows
	            $explicit_knowall_price_id_disallows_analytics = array('6');
	            $explicit_knowall_price_id_disallows_analytics = apply_filters( 'explicit_knowall_price_id_disallows_analytics', $explicit_knowall_price_id_disallows_analytics );
	            if( in_array( $knowall_license_price_id, $explicit_knowall_price_id_disallows_analytics ) ){
	                $allow = false;
	            }

	            //explicit allows
	            $explicit_knowall_price_id_allows_analytics = array();
	            $explicit_knowall_price_id_allows_analytics = apply_filters( 'explicit_knowall_price_id_allows_analytics', $explicit_knowall_price_id_allows_analytics );
	            if( in_array( $knowall_license_price_id, $explicit_knowall_price_id_allows_analytics ) ){
	                $allow = true;
	            }


	        }

	        return $allow;

	    }
		
	}

}

if( class_exists( 'HT_KnowAll_Support_Helpers' ) ){
	$ht_knowall_support_helpers = new HT_KnowAll_Support_Helpers();
}