//# sourceMappingURL=ht-blocks-tabs-block-source.jsx.map
/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

const { __ } = wp.i18n; // Import __() from wp.i18n
const { registerBlockType } = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText,
  InnerBlocks,
} = wp.editor;

const {
	Panel,
	PanelBody,
	PanelRow,
	RangeControl,
	SelectControl,
	TextControl,
    Dashicon, 
    Tooltip,
} = wp.components;

const { Fragment, Component } = wp.element;

const blockIcon = (
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" strokeWidth="2">
                <g fill="none" stroke="#555d66" strokeLinecap="square" strokeMiterlimit="10">
                    <path d="M1 8h22"/>
                    <path d="M23 23H1V1h9l2 3h11z"/>
                </g>
            </svg>
        );


/**
 * Register Block
 */
registerBlockType( 'ht-blocks/tabs', {
    title: __( 'Heroic Blocks - Tabs' ),
    description: __( 'This is the tabs block used for sections' ), 
    icon: {
            src: blockIcon,
            foreground: 'auto',
        },
    category: 'heroic-blocks', 
    keywords: [
        __( 'Heroic Blocks' ),
        __( 'Tabs' ),
        __( 'tabs' ),
    ],

    attributes: {
        selectedItem: {
            type: 'integer',
            default: 0
        },
        baseClassName: {
            type: 'string',
            default: 'wp-block-hb-tabs'
        }, 
        tabHeaders: {
            type: 'array',
            source: 'query',
            selector: '.wp-block-hb-tabs__head',
            query: { 
                    head: {
                        type: 'string',
                        source: 'html',
                        selector: 'span'
                    },
            },
            default: [
                {
                    head: ''

                },
                {
                    head: ''
                },
                {
                    head: ''
                },
            ]
        },
        tabContents: {
            type: 'array',
            source: 'query',
            selector: '.wp-block-hb-tabs__content',
            query: { 
                    contents: {
                        type: 'string',
                        source: 'html',
                        selector: 'p'
                    },
            },
            default: [
                {
                    contents: ''
                },
                {
                    contents: ''
                },
                {
                    contents: ''
                },
            ]
        }
    },

    edit: function( {className, attributes, setAttributes} ) {
        const { tabHeaders, tabContents, baseClassName, selectedItem } = attributes;

        const updateTabHead = ( index, newHead ) => {
            //create copy with modified values
            var newTabHeaders = [...tabHeaders];
            newTabHeaders[index].head = newHead;

            setAttributes( { tabHeaders: newTabHeaders } );
        }

        const updateTabContent = ( index, newContent ) => {
            //create copy with modified values
            var newTabContents = [...tabContents];
            newTabContents[index].contents = newContent;

            setAttributes( { tabContents: newTabContents } );
        }


        const addTab = () => {

            console.log('add tab clicked');
            var newHeadSection = {  head: {
                                        type: 'string',
                                        source: 'html',
                                        selector: 'span'
                                    }
                                }; 

            setAttributes( { tabHeaders: [ ...tabHeaders, newHeadSection ] } );

            var newContentSection = {  contents: {
                                            type: 'string',
                                            source: 'html',
                                            selector: 'p'
                                        }                                   
                                    };

            setAttributes( { tabContents: [ ...tabContents, newContentSection ] } );
            setAttributes( { selectedItem: tabContents.length } );

        }
         
        const removeTab = ( index ) => {
            console.log('remove tab clicked index->' + index);
            const confirmMsg = __( 'Are you sure you wish to remove this tab?' ) ;
            if( confirm(confirmMsg) ){
                setAttributes( { tabHeaders: tabHeaders.filter( (el, indx) => indx !== index ) } );
                setAttributes( { tabContents: tabContents.filter( (el, indx) => indx !== index ) } );
            }
        }

        const onTabHeadClick = (index) => {
            console.log('onTabHeadClick');
            console.log(index);
            console.log('#'+ baseClassName + '__section_' + index);
            setAttributes( { selectedItem: index } );
            return index;
        }
         

        var defaultState = { '' : 'inactive'};

        return (
            <Fragment>
                <InspectorControls
                    key='inspector'
                >
                    <PanelBody
                        title={ __( 'Tabs' ) }
                        className='heroic-blocks-tabs-panel-body'
                        initialOpen={ true }
                    >
                        <div className='ht-blocks-tabs-block-control'>{ __( 'Control this tabs block' ) }</div>
                    </PanelBody>
                </InspectorControls>
                <div className={ baseClassName }> 
                    <ul className={ baseClassName + '__nav' } role='tablist'>                         
                    {tabHeaders.map( ( header, index ) => (
                                       <li className = { baseClassName + '__head' } data-tab={`hb-tabs-${index}`} data-hb-tabs-tab--state={ selectedItem==index ? 'active' : 'inactive' }>
                                            <RichText   tagName='span' 
                                                        key = { index }
                                                        className = { baseClassName + '__head_item' }
                                                        unstableOnFocus={ () => onTabHeadClick(index) }
                                                        value={ header.head } 
                                                        for={ 'tab' + index }
                                                        onClick={ () => onTabHeadClick(index) }
                                                        onChange={ ( newSectionHead ) => updateTabHead( index, newSectionHead ) } 
                                                        placeholder={ __( 'Tab Heading' ) + ' ' + (index+1).toString() }
                                                        keepPlaceholderOnFocus={ true }                                                        
                                            />
                                            <Tooltip text={ __( 'Remove Section' ) }>
                                                <span onClick={ () => removeTab(index) } className={ baseClassName + '__remove_btn' }>
                                                    <Dashicon icon='dismiss'/>
                                                </span>
                                            </Tooltip>       
                                        </li>                   
                            
                    ) ) }
                    { /* add new button as li */ }
                        <li clasName = { baseClassName + '__add_tab' } >
                            <Tooltip text={ __( 'Add Tab' ) }>
                                <span onClick={ addTab } className={ baseClassName + '__add_btn' }>
                                    <Dashicon icon='plus-alt'/>
                                </span>
                            </Tooltip>
                        </li>
                    </ul>
                     {tabContents.map( ( content, index ) => (
                                <div id={`hb-tabs-${index}`} className={ baseClassName + '__content' } role='tabpanel' data-hb-tabs-tab--state={ selectedItem==index ? 'active' : 'inactive' }>
                                    <RichText   tagName='p' 
                                                key = { index }
                                                value={ content.contents } 
                                                onChange={ ( newSectionContent ) => updateTabContent( index, newSectionContent ) } 
                                                placeholder={ __( 'Enter your content here for tab ' ) + ' ' + (index+1).toString()  }
                                                keepPlaceholderOnFocus={ true }
                                    />
                                </div>                              
                            
                    ) ) }
                </div>
            </Fragment>
        );
    },


    save: function( {  attributes  } ) {

        const { tabHeaders, tabContents, baseClassName } = attributes;

        //reset selected item
        const selectedItem = 0;

        var defaultState = { 'data-hb-tabs-tab--state' : 'inactive'};

        return (
                    <div className={ baseClassName }>    
                        <ul className={ baseClassName + '__nav' } role='tablist'>                    
                            {tabHeaders.map( ( header, index ) => (
                                <li className = { baseClassName + '__head' } data-tab={`tabs-${index}`} data-hb-tabs-tab--state={ selectedItem==index ? 'active' : 'inactive' }>
                                        <RichText.Content 
                                            tagName='span' 
                                            className = { baseClassName + '__head_item' }
                                            key={ index }
                                            for={ 'tab' + index }  
                                            value={ header.head }  
                                        />
                                </li>
                            ) ) }
                        </ul>
                        {tabContents.map( ( content, index ) => (
                                <div id={`tabs-${index}`} className={ baseClassName + '__content' } role='tabpanel' data-hb-tabs-tab--state={ selectedItem==index ? 'active' : 'inactive' }>
                                        <RichText.Content 
                                            tagName='p' 
                                            value={ content.contents } 
                                        />
                                </div>
                        ) ) }
                    </div>

        );
    },

} );

console.log('Tabs Block Loaded');
