//# sourceMappingURL=ht-blocks-accordion-block-source.jsx.map
/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

const { __ } = wp.i18n; // Import __() from wp.i18n
const { registerBlockType } = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText,
  InnerBlocks,
} = wp.editor;

const {
    Panel,
    PanelBody,
    PanelRow,
    RangeControl,
    SelectControl,
    TextControl,
    Dashicon, 
    Tooltip,
} = wp.components;

const { Fragment, Component } = wp.element;

const blockIcon = (          
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" strokeWidth="2">
                        <g fill="none" stroke="#555d66" strokeLinecap="square" strokeMiterlimit="10">
                            <path d="M2 10h20v4H2z"/>
                            <path d="M2 2h20v4H2zM2 18h20v4H2z"/>
                        </g>
                    </svg>
        );


/**
 * Register Block
 */
registerBlockType( 'ht-blocks/accordion', {
    title: __( 'Heroic Blocks - Accordion' ),
    description: __( 'This is the accordion block used for sections' ), 
    icon: {
            src: blockIcon,
            foreground: 'auto',
        },
    category: 'heroic-blocks', 
    keywords: [
        __( 'Heroic Blocks' ),
        __( 'Accordion' ),
        __( 'accordion' ),
    ],

    attributes: {
        baseClassName: {
            type: 'string',
            default: 'wp-block-hb-accordion'
        }, 
        sections: {
            type: 'array',
            source: 'query',
            selector: '.wp-block-hb-accordion__section',
            query: { 
                    head: {
                        type: 'string',
                        source: 'html',
                        selector: '.wp-block-hb-accordion__title span'
                    },
                    content: {
                        type: 'string',
                        source: 'html',
                        selector: '.wp-block-hb-accordion__contentwrap'
                     }
            },
            default: [
                {
                    head: '',
                    content: ''
                },
                {
                    head: '',
                    content: ''
                },
                {
                    head: '',
                    content: ''
                },
            ]
        }
    },

    edit: function( {className, attributes, setAttributes} ) {
        const { content, sections, baseClassName } = attributes;

        const updateAccordionSectionHead = ( index, newSectionHead ) => {
            //create copy with modified values
            var newSections = [...sections];
            newSections[index].head = newSectionHead;

            setAttributes( { sections: newSections } );
        }

        const updateAccordionSectionContent = (index, newSectionContent ) => {
            //create copy with modified values
            var newSections = [...sections];
            newSections[index].content = newSectionContent;

            setAttributes( { sections: newSections } );
        }

        const addSection = () => {

            console.log('add section clicked');
            var newSection = {  head: {},
                                content: {}
                            };

            setAttributes( { sections: [ ...sections, newSection ] } );
        }
         
        const removeSection = (index) => {
            console.log('remove section clicked index->' + index);
            const confirmMsg = __( 'Are you sure you wish to remove this section?' ) ;
            if( confirm(confirmMsg) ){
                setAttributes( { sections: sections.filter( (el, indx) => indx !== index ) } );
            }
        }
         

        var defaultState = {'data-ht-blocks-accordion-block-state': 'closed'};

        return (
            <Fragment>
                <InspectorControls
                    key='inspector'
                >
                    <PanelBody
                        title={ __( 'Accordion' ) }
                        className='heroic-blocks-accordion-panel-body'
                        initialOpen={ true }
                    >
                        <div className='ht-blocks-accordion-block-control'>{ __( 'Control this accordion block' ) }</div>
                    </PanelBody>
                </InspectorControls>
                <div className={ className + ' ' + baseClassName }>                        
                    {sections.map( ( section, index ) => (
                            <Fragment key={ index }>
                                <div className={ baseClassName + '__section' + ' ' + baseClassName + '__section--active' } {...defaultState} >
                                    <div className={ baseClassName + '__title' }>
                                        <RichText   tagName='span' 
                                                    value={ section.head } 
                                                    onChange={ ( newSectionHead ) => updateAccordionSectionHead( index, newSectionHead ) } 
                                                    placeholder={ __( 'Accordion Heading' ) + ' ' + (index+1).toString() }
                                                    keepPlaceholderOnFocus={ true } 
                                        />
                                        <Tooltip text={ __( 'Remove Section' ) }>
                                            <span onClick={ () => removeSection(index) } className={ baseClassName + '__remove_btn' }>
                                                <Dashicon icon='dismiss'/>
                                            </span>
                                        </Tooltip>
                                    </div>
                                    <div className={ baseClassName + '__content' }>
                                        <RichText   tagName='div' 
                                                    className={ baseClassName + '__contentwrap' } 
                                                    value={ section.content } 
                                                    onChange={ ( newSectionContent ) => updateAccordionSectionContent( index, newSectionContent ) } 
                                                    placeholder={ __( 'Enter your content here for accordion section ' ) + ' ' + (index+1).toString() }
                                                    keepPlaceholderOnFocus={ true }
                                        />
                                    </div>
                                </div>
                                
                            </Fragment>
                    ) ) }
                    <Tooltip text={ __( 'Add Section' ) }>
                        <span onClick={ addSection } className={ baseClassName + '__add_btn' }>
                            <Dashicon icon='plus-alt'/>
                        </span>
                    </Tooltip>
                </div>
            </Fragment>
        );
    },


    save: function( {  attributes  } ) {

        const { sections, baseClassName } = attributes;

        var defaultState = {'data-ht-blocks-accordion-block-state': 'closed'};

        return (
                    <div className={ baseClassName }>                        
                        {sections.map( ( section, index ) => (
                                <Fragment>
                                    <div className={ baseClassName + '__section' } {...defaultState} >
                                        <div className={ baseClassName + '__title' }>
                                            <RichText.Content tagName='span' value={ section.head }  />
                                        </div>
                                        <div className={ baseClassName + '__content' }>
                                            <RichText.Content tagName='div' className={ baseClassName + '__contentwrap' } value={ section.content } />
                                        </div>
                                    </div>
                                </Fragment>
                        ) ) }
                    </div>

        );
    },

} );

console.log('Accordion Block Loaded');