<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MalwareState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;
/**
* MalwareState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MalwareState extends Entity
{
    /**
    * Gets the category
    * Provider-generated malware category (for example, trojan, ransomware, etc.).
    *
    * @return string The category
    */
    public function getCategory()
    {
        if (array_key_exists("category", $this->_propDict)) {
            return $this->_propDict["category"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category
    * Provider-generated malware category (for example, trojan, ransomware, etc.).
    *
    * @param string $val The value of the category
    *
    * @return MalwareState
    */
    public function setCategory($val)
    {
        $this->_propDict["category"] = $val;
        return $this;
    }
    /**
    * Gets the family
    * Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
    *
    * @return string The family
    */
    public function getFamily()
    {
        if (array_key_exists("family", $this->_propDict)) {
            return $this->_propDict["family"];
        } else {
            return null;
        }
    }

    /**
    * Sets the family
    * Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
    *
    * @param string $val The value of the family
    *
    * @return MalwareState
    */
    public function setFamily($val)
    {
        $this->_propDict["family"] = $val;
        return $this;
    }
    /**
    * Gets the name
    * Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
    *
    * @return string The name
    */
    public function getName()
    {
        if (array_key_exists("name", $this->_propDict)) {
            return $this->_propDict["name"];
        } else {
            return null;
        }
    }

    /**
    * Sets the name
    * Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
    *
    * @param string $val The value of the name
    *
    * @return MalwareState
    */
    public function setName($val)
    {
        $this->_propDict["name"] = $val;
        return $this;
    }
    /**
    * Gets the severity
    * Provider-determined severity of this malware.
    *
    * @return string The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            return $this->_propDict["severity"];
        } else {
            return null;
        }
    }

    /**
    * Sets the severity
    * Provider-determined severity of this malware.
    *
    * @param string $val The value of the severity
    *
    * @return MalwareState
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
        return $this;
    }
    /**
    * Gets the wasRunning
    * Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
    *
    * @return bool The wasRunning
    */
    public function getWasRunning()
    {
        if (array_key_exists("wasRunning", $this->_propDict)) {
            return $this->_propDict["wasRunning"];
        } else {
            return null;
        }
    }

    /**
    * Sets the wasRunning
    * Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
    *
    * @param bool $val The value of the wasRunning
    *
    * @return MalwareState
    */
    public function setWasRunning($val)
    {
        $this->_propDict["wasRunning"] = $val;
        return $this;
    }
}
