(function() {
    tinymce.create('tinymce.plugins.HTTabs', {
        HTTabs : function(ed, url) {
            //add the htshortcodes-tabs cmd
            ed.addCommand('htshortcodes-tabs', function() {
                var selectedText = ed.selection.getContent();
                //use global display modal function
                var completeAction = function(values){
                    console.log(values);
                    
                    var returnText = '';
                    var tabCount = extractOptionFromSerializedArray(values, 'tab-count');
                    var tabCountInt = parseInt(tabCount);
                    
                    var tabs = { heads : [], contents : [] } ;

                    //array position tracker
                    var x = 1;

                    //beware - this functionality relies on the values from the arraySerialization of the form to be ordered and not poulted 
                    //(eg by some sort of form injection)

                    //populate tabs
                    for (var i = 1; i < values.length; i=i+1) {
                        try{
                            //head and content check
                            if(values[i].name=="tab-head" && values[i+1].name=="tab-content"){
                                //head value
                                var head = values[i].value;
                                //content value
                                var content = values[i+1].value;
                                tabs.heads[x] = head;
                                tabs.contents[x] = content;
                                //increment array position tracker
                                x = x+1;
                            }

                        } catch( err ){
                            console.log('error');
                        }                        

                    }

                    returnText = '[ht_tabs tabs="' + tabCount + '" ';

                    for (var i = 1; i < tabCountInt+1; i++) {

                        returnText += ' tab_head_' + i + '=\'' + tabs.heads[i] + '\' ';
                        returnText += ' tab_content_' + i + '=\'' + tabs.contents[i] + '\' ';

                    }

                    returnText += getGlobalShortcodeVariables(values);

                    returnText += ']';
                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }

                //helpers
                var tabHeadHelper = htShortcodesPHPData.shortcodeTabsTabTitleHelper;
                var tabContentHelper = htShortcodesPHPData.shortcodeTabsTabContentHelper;

                var defaultNoOfTabs = 3;
                var windowTitle = htShortcodesPHPData.shortcodeTabsWindowTitle;
                var form =  "<div id='ht-shortcodes-tabs-entry'>";
                form +=         "<input id='ht-shortcodes-tabs-tabs-count' name='tab-count' type='text' value='"+defaultNoOfTabs+"'>";
                form +=             "<ul id='ht-shortcodes-tabs-tabs'>";
                for (var i = 1; i < defaultNoOfTabs+1; i++) {
                    form += getTabLiCode();        
                };
                form +=             "</ul>";
                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);

                updateTabIDs();
                initializeButtons();


                function removeAccordionTab(idToRemove){
                    console.log('#ht-shortcodes-tabs-tab-'+idToRemove);
                    jQuery('li.ht-shortcodes-tabs-tab').each(function(){
                         var tab = jQuery(this);
                         var tabID = tab.attr('data-id');
                         console.log('tabID->'+tabID);
                         if(tabID == idToRemove){
                            console.log('removing->'+tabID);
                            tab.slideUp('slow', function(){
                                tab.remove();
                                updateTabIDs();
                            });
                            
                         }

                    });

                }

                function initializeButtons(){
                    jQuery('a.ht-shortcodes-remove-tabs-tab').each(function(){

                        var removeBtn = jQuery(this);
                        //remove prior handlers
                        removeBtn.off();
                        
                        removeBtn.click(function( event ){
                            event.preventDefault();
                            target = jQuery(event.target);
                            var idToRemove = target.parent('li.ht-shortcodes-tabs-tab').attr('data-id');
                            console.log('click remove');
                            console.log(idToRemove);
                            removeAccordionTab(idToRemove);
                        });
                    });
                    jQuery('a.ht-shortcodes-add-tabs-tab').each(function(){
                        var addBtn = jQuery(this);
                        //remove prior handlers
                        addBtn.off();
                        addBtn.click(function( event ){
                            event.preventDefault();
                            target = jQuery(event.target);
                            var parentTab = target.parent('li.ht-shortcodes-tabs-tab');
                            var idToRemove = parentTab.attr('data-id');
                            parentTab.after(getTabLiCode()).show('slow');
                            updateTabIDs();
                            initializeButtons();
                        });
                    });
                }

                function onFocusActions(){
                    jQuery('input.ht-shortcodes-tabs-head, textarea.ht-shortcodes-tabs-content').each(function(){

                        var input = jQuery(this);

                        input.click(function() {
                            jQuery(this).select();
                        });

                        input.focus(function() {
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);
                        });


                    });
                }

                onFocusActions();

                function initialFocusAction(){
                    jQuery('input.ht-shortcodes-tabs-head, textarea.ht-shortcodes-tabs-content').first().each(function(){                    
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);

                     });
                }

                initialFocusAction();

                //get the li code for a tab
                function getTabLiCode(){
                    var li = "<li class='ht-shortcodes-tabs-tab' data-id='0'>";
                    li +=  "<input class='ht-shortcodes-tabs-head' name='tab-head' type='text' value='"+tabHeadHelper+"'>";
                    li +=  "<textarea cols='10' class='ht-shortcodes-tabs-content' name='tab-content'>"+tabContentHelper+"</textarea>";
                    li +=  "<a href='' class='ht-shortcodes-remove-tabs-tab'>"+"-"+"<span class='ht-tooltip'>Remove Tab</span></a> ";
                    li +=  "<a href='' class='ht-shortcodes-add-tabs-tab'>"+"+"+"<span class='ht-tooltip'>Add Tab</span></a>";
                    li +=  "</li>";
                    return li;

                }

                function updateTabIDs(){
                    //tracker counter
                    var i = 1;
                    jQuery('li.ht-shortcodes-tabs-tab').each(function(){
                         var tab = jQuery(this);
                         tab.attr('data-id', i);
                         i++;
                    });
                    //reset the no of tabs
                    setNoTabs(i-1);
                }

                function setNoTabs(count){
                    jQuery('#ht-shortcodes-tabs-tabs-count').val(count);
                }
                
            });
        }

    });

    // Register plugin
    tinymce.PluginManager.add( 'httabs', tinymce.plugins.HTTabs );
})();