<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Social module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Social' ) ){
	class HT_Shortcodes_Social {
		static $add_script;
		static $social_delimited;

		//Constructor
		static function init(){

			//add shortcode
			add_shortcode( 'ht_social_share' , array( __CLASS__, 'ht_social_shortcode' ) );
			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to register frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 

			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );

			//add filter to load editor styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_register_scripts' ) );
			//add filter to print editor styles and scripts
			add_action( 'wp_footer', array( __CLASS__, 'ht_shortcodes_print_scripts' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );

			//initialize the default social values
			self::$social_delimited = "facebook, twitter, gplus";

		}

		static function ht_social_shortcode($atts, $content = null){
			$social_attrs = shortcode_atts( array(
				'shares' => "",
			), $atts, 'ht_social_share' );

			extract( $social_attrs );

			//turn shares into array
			$shares = (empty($shares)) ? array_map('trim', explode(',', self::$social_delimited)) : array_map('trim', explode(',', $shares));

			//script required
			self::$add_script = true;

			ob_start();
    		?>
    		<div class="ht-shortcodes-social">
    			<div class="social-likes">
    				<?php
    					foreach ($shares as $key => $share) {
    						switch ($share) {
    							//must add any new shares here
    							case 'twitter':
	    							?>
	    								<div class="twitter" title="Share link on Twitter">Twitter</div>
	    							<?php
	    							break;
	    						case 'facebook':
	    							?>
	    								<div class="facebook" title="Share link on Facebook">Facebook</div>
	    							<?php
	    							break;
	    						
	    						case 'gplus':
	    							?>
	    								<div class="plusone" title="Share link on Google+">Google+</div>
	    							<?php
	    							break;
	    						default:
	    								# code...
	    								break;
    						}

    					}
    				?>					
				</div>
    			
    		</div><!-- /.ht-shortcodes-social -->
    		<?php
			return ob_get_clean();
		}


		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'social');
			if($load_module){
				//append to elements menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'elements' ){
						array_push($submenu['menu'], array('id'=>'social', 'text'=>__('Social', 'ht-shortcodes'), 'cmd'=>'htshortcodes-social'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'social');
			if($load_module){
				$plugin_array['htsocial'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-social-backend.js';
			}
			return $plugin_array;
		}

		/**
		* Register frontend styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'social');
			if(!$theme_loads_frontend_styles){
				wp_register_style( 'ht-shortcodes-social-frontend-style', plugins_url( 'ht-shortcodes-social-frontend.css', __FILE__ ));
			}
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'social');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-social-backend-style', plugins_url( 'ht-shortcodes-social-backend.css', __FILE__ ));
			}
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		static function ht_shortcodes_filter_mce_css( $mce_css ) {
			$mce_css .= ', ' . plugins_url( 'ht-shortcodes-social-editor.css', __FILE__ );
			return $mce_css;
		}

		/**
		* Register front end script
		*/
		static function ht_shortcodes_register_scripts() {
			wp_register_script('ht-shortcodes-social-frontend-script', plugins_url( 'ht-shortcodes-social-frontend.js', __FILE__ ), array('jquery'), '1.0', true);
		}

		/**
		* Print front end scripts if shortcodes are used
		*/
		static function ht_shortcodes_print_scripts() {
			if ( ! self::$add_script )
				return;

			wp_print_scripts('ht-shortcodes-social-frontend-script');
			wp_print_styles('ht-shortcodes-social-frontend-style');
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeSocialWindowTitle'] = __('Add new Social Share Buttons', 'ht-shortcodes');


			return $data;
		}








	} //end class HT_Shortcodes_Social
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Social' ) ){
	 HT_Shortcodes_Social::init();
}