<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Messages module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Messages' ) ){
	class HT_Shortcodes_Messages {
		static $add_script;

		static $message_styles;

		//Constructor
		static function init(){

			//initialize message styles, to add a new message style also create relevant front css
			self::$message_styles = array(
										'alert' => __('Alert (yellow)', 'ht-shortcodes'),
										'success' => __('Success (green)', 'ht-shortcodes'),
										'danger' => __('Danger (red)', 'ht-shortcodes'),
										'info' => __('Information (blue)', 'ht-shortcodes'),
										//'coupon' => __('Coupon', 'ht-shortcodes'),
				);

			//add shortcode
			add_shortcode( 'ht_message' , array( __CLASS__, 'ht_messages_shortcode' ) );
			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to register frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 

			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );

			//add filter to load editor styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_register_scripts' ) );
			//add filter to print editor styles and scripts
			add_action( 'wp_footer', array( __CLASS__, 'ht_shortcodes_print_scripts' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );


			

		}

		/**
		* The shortcode filter
		*/
		static function ht_messages_shortcode($atts, $content = null){
			$messages_attrs = shortcode_atts( array(
				'mstyle' => 'alert',
				'title' => '',
				'show_icon' => true,
				'icon' => false,
				'id' => '',
				'class' => '',
				'style' => '',
			), $atts, 'ht_message' );

			extract( $messages_attrs );

			//script required
			self::$add_script = true;

			$title_css = (''!=$title) ? 'hts-messages--withtitle' : '';
			$icon_css = ($show_icon!=false) ? 'hts-messages--withicon' : '';
			$id_output = (''!=$id) ? 'id="' . $id . '"' : '';
			$style_output = (''!=$style) ? 'style="' . $style . '"' : '';

			//show_title now available (default true)
			ob_start();
    		?>
    		<div class="hts-messages hts-messages--<?php echo $mstyle; ?>  <?php echo $title_css; ?> <?php echo $icon_css; ?> <?php echo $class; ?>" <?php echo $id_output; ?> <?php echo $style_output; ?> >
    			<?php if( $title!='' ) : ?><span class="hts-messages__title"><?php echo $title; ?></span><?php endif; ?>
    			<?php if ( !empty($content) ) : ?>
    				<p>
    					<?php echo $content; ?>
    				</p>
    			<?php endif; ?>
    			
    		</div><!-- /.ht-shortcodes-messages -->
    		<?php
			return ob_get_clean();
		}


		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'messages');
			if($load_module){
				//append to layout menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'styling' ){
						array_push($submenu['menu'], array('id'=>'messages', 'text'=>__('Messages', 'ht-shortcodes'), 'cmd'=>'htshortcodes-messages'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'messages');
			if($load_module){
				$plugin_array['htmessages'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-messages-backend.js';
			}
			return $plugin_array;
		}

		/**
		* Register frontend styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'messages');
			if(!$theme_loads_frontend_styles){
				wp_register_style( 'ht-shortcodes-messages-frontend-style', plugins_url( 'ht-shortcodes-messages-frontend.css', __FILE__ ));
			}
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'messages');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-messages-backend-style', plugins_url( 'ht-shortcodes-messages-backend.css', __FILE__ ));
			}
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		static function ht_shortcodes_filter_mce_css( $mce_css ) {
			$mce_css .= ', ' . plugins_url( 'ht-shortcodes-messages-editor.css', __FILE__ );
			return $mce_css;
		}

		/**
		* Register front end script
		*/
		static function ht_shortcodes_register_scripts() {
			wp_register_script('ht-shortcodes-messages-frontend-script', plugins_url( 'ht-shortcodes-messages-frontend.js', __FILE__ ), array('jquery'), '1.0', true);
		}

		/**
		* Print front end scripts if shortcodes are used
		*/
		static function ht_shortcodes_print_scripts() {
			if ( ! self::$add_script )
				return;

			wp_print_scripts('ht-shortcodes-messages-frontend-script');
			wp_print_styles('ht-shortcodes-messages-frontend-style');
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeMessagesWindowTitle'] = __('Add new Message', 'ht-shortcodes');

			$data['shortcodeMessagesEntryHelper'] = __('Your message goes here', 'ht-shortcodes');
			$data['shortcodeMessagesStyleLabelHelper'] = __('Style', 'ht-shortcodes');
			$data['shortcodeMessagesTitleLabelHelper'] = __('Message Title', 'ht-shortcodes');
			$data['shortcodeMessagesTitlePlaceholderHelper'] = __('Title', 'ht-shortcodes');
			$data['shortcodeMessagesEntryLabelHelper'] = __('Message', 'ht-shortcodes');
			$data['shortcodeMessagesShowTitleHelper'] = __('Show Title', 'ht-shortcodes');
			$data['shortcodeMessagesShowIconHelper'] = __('Show Icon', 'ht-shortcodes');

			$data['shortcodeMessagesStyles'] = self::$message_styles;


			return $data;
		}


		/**
		* Extract messages messages from array
		* @param (Array) $attr The raw attributes
		* @return (Array) The extracted messages
		*/
		static function ht_shortcodes_extract_messages_messages($attr){
			$messages = array();

			return $messages;
		}






	} //end class HT_Shortcodes_Messages
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Messages' ) ){
	 HT_Shortcodes_Messages::init();
}
