<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Icons module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Icons' ) ){
	class HT_Shortcodes_Icons {
		static $add_script;

		static $icons_array;

		//Constructor
		static function init(){


			
			//initialize icons
			self::$icons_array = array('icon-cancel');
			//get the icon list and assign it
			@include_once('ht-shortcodes-icons-list.php');
			if(class_exists('HT_Shortcodes_Icons_List')) {
				self::$icons_array = HT_Shortcodes_Icons_List::$icons_list;
			} 
			//add shortcode
			add_shortcode( 'ht_icon' , array( __CLASS__, 'ht_icons_shortcode' ) );
			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to register frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 

			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );

			//add filter to load editor styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_register_scripts' ) );
			//add filter to print editor styles and scripts
			add_action( 'wp_footer', array( __CLASS__, 'ht_shortcodes_print_scripts' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );

		}

		/**
		* The shortcode filter
		*/
		static function ht_icons_shortcode($atts, $content = null){
			$icons_attrs = shortcode_atts( array(
				'icon' => '',
				'icon_color' => '#000',
				'icon_size' => '12',
				'id' => '',
				'class' => '',
				'style' => '',
			), $atts, 'ht_icon' );

			extract( $icons_attrs );

			$style  .= " font-size:" .  $icon_size . "px;";
			$style  .= " color:" .  $icon_color . ";";

			//script required
			self::$add_script = true;
			ob_start();
    		?>
    		<span class="ht-shortcodes-icons  <?php echo $class; ?>" id="<?php echo $id; ?>" style="<?php echo $style; ?>">
    			<i class="<?php echo $icon; ?>"></i>
    			
    		</span><!-- /.ht-shortcodes-icons -->
    		<?php
			return ob_get_clean();
		}


		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'icons');
			if($load_module){
				//append to layout menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'styling' ){
						array_push($submenu['menu'], array('id'=>'icons', 'text'=>__('Icons', 'ht-shortcodes'), 'cmd'=>'htshortcodes-icons'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'icons');
			if($load_module){
				$plugin_array['hticons'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-icons-backend.js';
			}
			return $plugin_array;
		}

		/**
		* Register frontend styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'icons');
			if(!$theme_loads_frontend_styles){
				wp_register_style( 'ht-shortcodes-icons-frontend-style', plugins_url( 'ht-shortcodes-icons-frontend.css', __FILE__ ));
				wp_enqueue_style( 'fontello-css', plugins_url( 'fontello-7275ca86/css/fontello.css', __FILE__ ));
				wp_enqueue_style( 'icomoon-css', plugins_url( 'icomoon/style.css', __FILE__ ));
			}
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'icons');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-icons-backend-style', plugins_url( 'ht-shortcodes-icons-backend.css', __FILE__ ));
				wp_enqueue_script( 'font-icon-picker-js', plugins_url( 'lib/jquery.fonticonpicker.min.js', __FILE__ ), 'jquery');
				wp_enqueue_style( 'font-icon-picker-css', plugins_url( 'lib/css/jquery.fonticonpicker.min.css', __FILE__ ));
				wp_enqueue_style( 'fontello-css', plugins_url( 'fontello-7275ca86/css/fontello.css', __FILE__ ));
				wp_enqueue_style( 'icomoon-css', plugins_url( 'icomoon/style.css', __FILE__ ));
			}		
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		static function ht_shortcodes_filter_mce_css( $mce_css ) {
			$mce_css .= ', ' . plugins_url( 'ht-shortcodes-icons-editor.css', __FILE__ );
			return $mce_css;
		}

		/**
		* Register front end script
		*/
		static function ht_shortcodes_register_scripts() {
			wp_register_script('ht-shortcodes-icons-frontend-script', plugins_url( 'ht-shortcodes-icons-frontend.js', __FILE__ ), array('jquery'), '1.0', true);
		}

		/**
		* Print front end scripts if shortcodes are used
		*/
		static function ht_shortcodes_print_scripts() {
			if ( ! self::$add_script )
				return;

			wp_print_scripts('ht-shortcodes-icons-frontend-script');
			wp_print_styles('ht-shortcodes-icons-frontend-style');
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeIconsWindowTitle'] = __('Add new Icon', 'ht-shortcodes');

			$data['shortcodeIconsEntryHelper'] = __('Your icon goes here', 'ht-shortcodes');
			$data['shortcodeIconsSelectorLabelHelper'] = __('Icon', 'ht-shortcodes');
			$data['iconTextColorHelper'] = __('Icon Color', 'ht-shortcodes');
			$data['iconTextSizeHelper'] = __('Icon Size (px)', 'ht-shortcodes');
			$data['iconInvalidSize'] = __('Invalid text size, please use numeric value only', 'ht-shortcodes');
			$data['shortcodeIcons'] = self::$icons_array;

			return $data;
		}


		/**
		* Extract icons icons from array
		* @param (Array) $attr The raw attributes
		* @return (Array) The extracted icons
		*/
		static function ht_shortcodes_extract_icons_icons($attr){
			$icons = array();

			return $icons;
		}



	} //end class HT_Shortcodes_Icons
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Icons' ) ){
	 HT_Shortcodes_Icons::init();
}
