<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Dropcaps Module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/

require_once('config.php');

if( !class_exists( 'HT_Shortcodes_Advert' ) ){
	class HT_Shortcodes_Advert {


		//Constructor
		static function init(){

			//shortcode
			add_shortcode( 'ht_ad', array( __CLASS__, 'ht_shortcodes_ad') );

			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to load frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles)
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) );
			//ajax functionality
			add_action( 'wp_ajax_ht_sc_advert_check_name', array( __CLASS__, 'ht_shortcodes_advert_check_name_ajax' ) );
			add_action( 'wp_ajax_ht_sc_advert_add_new_code', array( __CLASS__, 'ht_shortcodes_advert_add_new_code_ajax' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );
		}

		static function ht_shortcodes_ad($atts){
			global $default_ad_units;
			$ads = get_option('ht_shortcodes_advert_adverts', $default_ad_units);
			return stripslashes($ads[$atts['advert']]['code']);
		}

		/**
		* Custom data filter for 18n
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$user_id = wp_get_current_user()->ID;
			global $default_ad_units;
			$data['advert-adverts'] = get_option('ht_shortcodes_advert_adverts', $default_ad_units);


			foreach($data['advert-adverts'] as $key => $value){
				$data['advert-adverts'][$key]['code'] = stripslashes($data['advert-adverts'][$key]['code']);
			}

			//i18n objects
			$data['shortcodeAdvertWindowTitle'] = __('Add new Advert', 'ht-shortcodes');
			$data['shortcodeAdvertNewUnitHelper'] = __('New Ad Unit', 'ht-shortcodes');
			$data['shortcodeAdvertNewUnitNameHelper'] = __('Ad Unit Name', 'ht-shortcodes');
			$data['shortcodeAdvertNewUnitCodeHelper'] = __('Ad Unit Code', 'ht-shortcodes');
			$data['shortcodeAdvertSubmitBtnHelper'] = __('OK', 'ht-shortcodes');
			$data['shortcodeAdvertInUseHelper'] = __('Ad Name already in use', 'ht-shortcodes');


			return $data;
		}

		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'advert');
			if($load_module){
				//append to styling menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'elements' ){
						array_push($submenu['menu'], array('id'=>'advert', 'text'=>__('Advert', 'ht-shortcodes'), 'cmd'=>'htshortcodes-advert'));
						}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'advert');
			if($load_module){
				$plugin_array['htadvert'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-advert.js';
			}
			return $plugin_array;
		}

		/**
		* Enqueue front end styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'advert');
			if(!$theme_loads_frontend_styles){
				//none required
			}
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		public static function ht_shortcodes_filter_mce_css( $mce_css ) {
			//na
			return $mce_css;
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'advert');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-advert-backend-style', plugins_url( 'ht-shortcodes-advert-backend.css', __FILE__ ));
			}
		}


		static function ht_shortcodes_advert_check_name_ajax(){
			//@todo - check ref and security?
			global $default_ad_units;
			//clean output
			if (ob_get_length()) ob_end_clean();

	        $ads = get_option('ht_shortcodes_advert_adverts', $default_ad_units);

	       if( $_GET['edit']=='false' && isset( $ads[$_GET['ad-name']] ) && !$ads[$_GET['ad-name']]['deleted'] ){
	           echo 'false';
	        }
	        else {
	            echo 'true';
	        }
	        die();
		}

		static function ht_shortcodes_advert_add_new_code_ajax(){
			//@todo - check ref and security?
			if(current_user_can('manage_options')){
		        global $default_ad_units;
		        //get current ads
		        $ads = get_option('ht_shortcodes_advert_adverts', $default_ad_units);
		        
		        if($_POST['ad-action'] == 'add'){
		        	//parse the serialized data into form data array
		        	//parse_str( $_POST['form'], $form_data);
		        	$form_data = $_POST['form'];


		        	$ad_name = HT_Shortcodes::extract_value_from_serialized_array( $form_data, 'ad-name' );
		        	$ad_code = HT_Shortcodes::extract_value_from_serialized_array( $form_data, 'ad-code' );
		        	$ads[$ad_name] = array('code' => $ad_code, 'deleted' => false);
		            //$ads[$form_data['ad-name']] = array("code" => $form_data['ad-code'], "deleted" => false);

		        } else if($_POST['ad-action'] == 'delete'){
		            $ads[$_POST['key']]['deleted'] = true;
		        }
		        //update the ads
		        update_option('ht_shortcodes_advert_adverts', $ads);
		    }
		}


	} //end class HT_Shortcodes_Dropcaps
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Advert' ) ){
	HT_Shortcodes_Advert::init();
}
