var adverts = getOption('advert-adverts');
var edit = false;
var ed;
var url;

var formValidation = {
    rules: {
        "ad-name": {
            required : true,
            maxlength:16,
            remote: {
                url: ajaxurl,
                type: "get",
                data: {
                    'action' : 'ht_sc_advert_check_name',
                    'ad-name' : function() {
                        return jQuery( "#ht-shortcodes-advert-selector #ad-name" ).val();
                    },
                    edit: function(){
                        return edit;
                    }

                }
            }

        },


        "ad-code": {
            required: true
        }
    },

    messages: {
        "ad-name":{
            remote: htShortcodesPHPData.shortcodeAdvertInUseHelper
        }
    },

    submitHandler: function(){
        var form = jQuery('form#ht-shortcodes-advert-selector')
        var formValues = form.serialize();
        var formValuesArray = form.serializeArray();
        jQuery.ajax({
            url: ajaxurl,
            data : {
                'action' : 'ht_sc_advert_add_new_code',
                'update-advert': true,
                'ad-action': 'add',
                'form': formValuesArray
            },
            type: "POST",
            async: false,
            success: function(data, textStatus, jqXHR){
                adverts[extractOptionFromSerializedArray(formValuesArray, 'ad-name')] = {code: extractOptionFromSerializedArray(formValuesArray, 'ad-code'), deleted: false}
                form.dialog("destroy").remove();
                showAdPanel();
            }
        });


    }
}

function getAdvertCode(name){
    if(!adverts[name]){
        return "";
    }
    return adverts[name]['code'];
}

function createSelectButtonHandler(item){
    return function(e){
        //console.log("select button handler");
        //console.log(item);
        //console.log(ed);

        event.preventDefault();
        var returnText = "[ht_ad advert='" + item + "']";
        ed.execCommand('mceInsertContent', 0, returnText);
        form.dialog("destroy").remove();
    }
}

function createDeleteButtonHandler(item){
    return function(e){
        jQuery.ajax({
            url: ajaxurl,

            data : {
                'action' : 'ht_sc_advert_add_new_code',
                'ad-action': 'delete',
                'update-advert' : true,
                'key' : item
            },
            type: "POST"
        });

        jQuery(this).parent().parent().fadeOut(200, function(){
            this.remove();
        });

        delete adverts[item];

    }
}

function createEditButtonHandler(adName){
    return function(e){
        edit = true;
        showAdEdit(adName);
    }
}

function createAdSelection(item, adCode){
    var parentSpan = jQuery("<span class='advert-selector-option'></span>")
    var buttonSpan = jQuery("<span class='advert-selector-buttons'>");
    var selectButton = jQuery("<button class='select-button'>Select</button>");
    var editButton   = jQuery("<span class='advert-selector-button'>Edit</span>")
    var deleteButton = jQuery("<span class='advert-selector-button'>Delete</span>");
    buttonSpan.append(selectButton);
    buttonSpan.append(editButton);
    buttonSpan.append(deleteButton);
    parentSpan.append("<span class='item'>" + item + "</span>");
    parentSpan.append(buttonSpan);
    parentSpan.append('<br /><div style="clear: both;"></div>');
    selectButton.click(createSelectButtonHandler(item));
    editButton.click(createEditButtonHandler(item));
    deleteButton.click(createDeleteButtonHandler(item));
    return parentSpan;
}

function showAdEdit(adName, adCode){
    jQuery("form#ht-shortcodes-advert-selector").dialog("destroy").remove();
    var form = jQuery("<form id='ht-shortcodes-advert-selector'></form>");
    form.validate(formValidation);

        var readonly = "";
        if(edit){
            readonly = "readonly"
        }

        adCreateForm = jQuery("<span id='ad-create-form'><label for='ad-name'>" + htShortcodesPHPData.shortcodeAdvertNewUnitNameHelper + "</label><br />" +
        "<input type='text' name='ad-name' id='ad-name' value='"+ htShortcodesPHPData.shortcodeAdvertNewUnitNameHelper +"' "+ readonly +"/><br /><br />" +
        "<label for='ad-code'>" + htShortcodesPHPData.shortcodeAdvertNewUnitCodeHelper + "</label><br />" +
        "<textarea type='text' name='ad-code' id='ad-code' cols=50 rows=10>"+ getAdvertCode(adName) +"</textarea><br /><br />" +
        "<button id='submit-new-ad'>" + htShortcodesPHPData.shortcodeAdvertSubmitBtnHelper  +"</button></span>");
        adCreateForm.appendTo(form);




        jQuery('#submit-new-ad').click(function (e){
            event.preventDefault();
            form.submit();
        });

        form.dialog({
            minWidth:500,
            title: htShortcodesPHPData.shortcodeAdvertWindowTitleHelper
        });

}

function showAdPanel(){


        form = jQuery("<form id='ht-shortcodes-advert-selector'>" +
                            "<button id='add-new'>"+ htShortcodesPHPData.shortcodeAdvertNewUnitHelper +"</button><br /><br />" +
                        "</form>");


        form.validate(formValidation);

        for(var item in adverts){
            var key = adverts[item];
            if (key['deleted'] === false){
                createAdSelection(item, key['code']).appendTo(form);
            }

        }


        form.dialog({
            minWidth:500,
            title: htShortcodesPHPData.shortcodeAdvertWindowTitle
        });
        jQuery("button#add-new").click(function (e){
            event.preventDefault();
            edit = false;
            showAdEdit("", "");
        });
}

(function() {
    tinymce.create('tinymce.plugins.HTAdvert', {
        HTAdvert : function(editor, u) {
            ed = editor;
            url = u;
            ed.addCommand('htshortcodes-advert', function() {
            showAdPanel();
        });
        }
    });

    // Register plugin
    tinymce.PluginManager.add( 'htadvert', tinymce.plugins.HTAdvert );

})();
