<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Accordion module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Accordion' ) ){
	class HT_Shortcodes_Accordion {
		static $add_script;

		//Constructor
		static function init(){

			//add shortcode
			add_shortcode( 'ht_accordion' , array( __CLASS__, 'ht_accordion_shortcode' ) );
			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to register frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 

			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );

			//add filter to load editor styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_register_scripts' ) );
			//add filter to print editor styles and scripts
			add_action( 'wp_footer', array( __CLASS__, 'ht_shortcodes_print_scripts' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );

		}

		static function ht_accordion_shortcode($atts, $content = null){
			$accordion_attrs = shortcode_atts( array(
				'sections' => 0,
				'id' => '',
				'class' => '',
				'style' => '',
			), $atts, 'ht_accordion' );

			extract( $accordion_attrs );

			//script required
			self::$add_script = true;

			ob_start();
    		?> 
    		<div class="hts-accordion <?php echo $class; ?>" <?php if ( !empty($id) ): ?> id="<?php echo $id; ?>" <?php endif; ?> <?php if ( !empty($style) ): ?> style="<?php echo $style; ?>"<?php endif; ?>>

    			<?php for ($i=1; $i < $sections+1 ; $i++) : ?>
    				<div class="hts-accordion__section <?php if ( $i == 1 ) : ?>hts-accordion__section--active<?php endif; ?>">
	    				<div class="hts-accordion__title"><?php echo $atts['section_head_'.$i]; ?></div>
	    				<div class="hts-accordion__content">
	    					<div class="hts-accordion__contentwrap">
	    						<?php echo $atts['section_content_'.$i]; ?>
	    					</div>
	    				</div>
    				</div>
    			<?php endfor; ?>
    			
    		</div><!-- /.ht-shortcodes-accordion -->
    		<?php
			return ob_get_clean();
		}


		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'accordion');
			if($load_module){
				//append to layout menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'layout' ){
						array_push($submenu['menu'], array('id'=>'accordion', 'text'=>__('Accordion', 'ht-shortcodes'), 'cmd'=>'htshortcodes-accordion'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'accordion');
			if($load_module){
				$plugin_array['htaccordion'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-accordion-backend.js';
			}
			return $plugin_array;
		}

		/**
		* Register frontend styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'accordion');
			if(!$theme_loads_frontend_styles){
				wp_register_style( 'ht-shortcodes-accordion-frontend-style', plugins_url( 'ht-shortcodes-accordion-frontend.css', __FILE__ ));
			}
			
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'accordion');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-accordion-backend-style', plugins_url( 'ht-shortcodes-accordion-backend.css', __FILE__ ));
			}			
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		static function ht_shortcodes_filter_mce_css( $mce_css ) {
			$mce_css .= ', ' . plugins_url( 'ht-shortcodes-accordion-editor.css', __FILE__ );
			return $mce_css;
		}

		/**
		* Register front end script
		*/
		static function ht_shortcodes_register_scripts() {
			wp_register_script('ht-shortcodes-accordion-frontend-script', plugins_url( 'ht-shortcodes-accordion-frontend.js', __FILE__ ), array('jquery'), '1.0', true);
		}

		/**
		* Print front end scripts if shortcodes are used
		*/
		static function ht_shortcodes_print_scripts() {
			if ( ! self::$add_script )
				return;

			wp_print_scripts('ht-shortcodes-accordion-frontend-script');
			wp_print_styles('ht-shortcodes-accordion-frontend-style');
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeAccordionWindowTitle'] = __('Add new Accordion', 'ht-shortcodes');


			return $data;
		}


		/**
		* Extract accordion sections from array
		* @param (Array) $attr The raw attributes
		* @return (Array) The extracted sections
		*/
		static function ht_shortcodes_extract_accordion_sections($attr){
			$sections = array();

			return $sections;
		}






	} //end class HT_Shortcodes_Accordion
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Accordion' ) ){
	 HT_Shortcodes_Accordion::init();
}
