(function() {
    tinymce.create('tinymce.plugins.HTToggle', {
        HTToggle : function(ed, url) {
            //add the htshortcodes-buttons cmd
            ed.addCommand('htshortcodes-toggle', function() {
                var selectedText = ed.selection.getContent();
                //use global display modal function
                var completeAction = function(values){
                    console.log(values);
                    var returnText = '';
                    var title = extractOptionFromSerializedArray(values, 'title');
                    var content = extractOptionFromSerializedArray(values, 'content');
                    returnText = '[ht_toggle title="'+title + '"';
                    returnText += getGlobalShortcodeVariables(values);
                    returnText += ']' + content + '[/ht_toggle]';
                    ed.execCommand('mceInsertContent', 0, returnText);
                }

                var previewTitle = htShortcodesPHPData.shortcodeTogglePreviewTitle;
                var windowTitle = htShortcodesPHPData.shortcodeToggleWindowTitle;
                var form =  "<div id='ht-shortcodes-toggle-entry'>";
                form +=         "<label>Toggle Title:</label>";
                form +=         "<input id='ht-shortcodes-toggle-entry-title' name='title' type='text' value='"+previewTitle+"'>";
                form +=         "<label>Toggle Content:</label>";
                form +=         "<textarea cols='10' id='ht-shortcodes-toggle-entry-content' name='content'>"+selectedText+"</textarea>";
                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);


                function onFocusActions(){
                    jQuery('input#ht-shortcodes-toggle-entry-title, textarea#ht-shortcodes-toggle-entry-content').each(function(){

                        var input = jQuery(this);

                        input.click(function() {
                            jQuery(this).select();
                        });

                        input.focus(function() {
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);
                        });


                    });
                }

                onFocusActions();

                function initialFocusAction(){
                    jQuery('input#ht-shortcodes-toggle-entry-title, textarea#ht-shortcodes-toggle-entry-content').first().each(function(){                    
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);

                     });
                }

                initialFocusAction();
                
            });
        }

    });


    // Register plugin
    tinymce.PluginManager.add( 'httoggle', tinymce.plugins.HTToggle );
})();