(function() {
    tinymce.create('tinymce.plugins.HTSocial', {
        HTSocial : function(ed, url) {
            //add the htshortcodes-social cmd
            ed.addCommand('htshortcodes-social', function() {
                var selectedText = ed.selection.getContent();

                var socialSharesOpts = ['facebook', 'twitter', 'gplus'];
                //use global display modal function
                var completeAction = function(values){
                    console.log(values);
                    
                    var returnText = '';

                    var shares = '';
                    
                    for (var i = values.length - 1; i >= 0; i--) {
                        //current social search item
                        var val = values[i].value;
                        if(socialSharesOpts.indexOf(val)>-1){
                            shares += val + ', ';
                        }
                    };

                    returnText = '[ht_social_share shares="'+ shares + '"]';

                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }

                //helpers
                var sectionHeadHelper = "Section Head";
                var sectionContentHelper = "Section Content";

                

                var windowTitle = htShortcodesPHPData.shortcodeSocialWindowTitle;
                var form =  "<div id='ht-shortcodes-social-entry'>";
                form +=             "<ul id='ht-shortcodes-social-sections'>";
                for (var i = 0; i < socialSharesOpts.length; i++) {
                    var shareItem = socialSharesOpts[i];
                    form += "<li><input type='checkbox' name='"+shareItem+"' value='"+shareItem+"'>"+shareItem+"</li>";
                };
                form +=             "</ul>";
                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);

            });
        } 

    });



    // Register plugin
    tinymce.PluginManager.add( 'htsocial', tinymce.plugins.HTSocial );
})();