(function() {
    tinymce.create('tinymce.plugins.HTMessages', {
        HTMessages : function(ed, url) {
            //add the htshortcodes-messages cmd
            ed.addCommand('htshortcodes-messages', function() {
                var selectedText = ed.selection.getContent();

                //use global display modal function
                var completeAction = function(values){
                    var selectedText = ed.selection.getContent();
                    var returnText = '';
                    var messageText = extractOptionFromSerializedArray(values, 'msg-text');
                    var messageStyle = extractOptionFromSerializedArray(values, 'msg-style'); 
                    var messageTitle = extractOptionFromSerializedArray(values, 'msg-title'); 
                    var messageShowIcon = '';
                    try{
                        messageShowIcon = extractOptionFromSerializedArray(values, 'show-icon');
                        messageShowIcon = 'true';
                    } catch (err){
                        //key not in array
                    }                    

                    returnText =   '[ht_message mstyle="'+ messageStyle +'" title="'+ messageTitle +'" show_icon="'+ messageShowIcon +'" ';
                    returnText +=  getGlobalShortcodeVariables(values);
                    returnText +=  ']';
                    returnText +=  messageText;                 
                    returnText +=  '[/ht_message]';
                    
                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }

                var windowTitle = htShortcodesPHPData.shortcodeMessagesWindowTitle;
                //helpers
                var entryHelper = htShortcodesPHPData.shortcodeMessagesEntryHelper;
                var shortcodeMessagesStyleLabelHelper = htShortcodesPHPData.shortcodeMessagesStyleLabelHelper;
                var titlePlaceholder = htShortcodesPHPData.shortcodeMessagesTitlePlaceholderHelper;
                var shortcodeMessagesTitleLabelHelper = htShortcodesPHPData.shortcodeMessagesTitleLabelHelper;
                var shortcodeMessagesEntryLabelHelper = htShortcodesPHPData.shortcodeMessagesEntryLabelHelper;
                var shortcodeMessagesShowIconHelper = htShortcodesPHPData.shortcodeMessagesShowIconHelper;
                var shortcodeMessagesShowTitleHelper = htShortcodesPHPData.shortcodeMessagesShowTitleHelper;

                /*
                if(selectedText==""){
                    //if no selected text use entry helper
                    selectedText = entryHelper;
                }
                */

                var form =  "<div id='ht-shortcodes-messages-entry'>";
                
                //select
                form +=         "<label>" + shortcodeMessagesStyleLabelHelper + "</label>"; 
                form +=         "<select name='msg-style' id='ht-shortcodes-messages-entry-style'>";    

                //add styles
                for (var key in htShortcodesPHPData.shortcodeMessagesStyles) {
                    var label = htShortcodesPHPData.shortcodeMessagesStyles[key];
                    form +=  "<option value='" + key + "'>" + label + "</option>";  
                };

                form +=         "</select>";
                //mesage area
                form +=         "<label>" + shortcodeMessagesTitleLabelHelper + "</label>"; 
                form +=         "<input id='ht-shortcodes-messages-title-text' name='msg-title' type='text' placeholder='" + titlePlaceholder + "'>";
                form +=         "</textarea>";
                form +=         "<label>" + shortcodeMessagesEntryLabelHelper + "</label>";     
                form +=         "<textarea id='ht-shortcodes-messages-entry-text' name='msg-text' placeholder='" + entryHelper + "'>";
                form +=             selectedText;
                form +=         "</textarea>";
                form +=         "<label><input id='ht-shortcodes-messages-show-icon' name='show-icon' type='checkbox' value='show_icon'>";
                form +=         ""+shortcodeMessagesShowIconHelper+"</label>";

                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);
                
            });
        }

    });



    // Register plugin
    tinymce.PluginManager.add( 'htmessages', tinymce.plugins.HTMessages );
})();
