(function() {
    tinymce.create('tinymce.plugins.HTIcons', {
        HTIcons : function(ed, url) {
            //add the htshortcodes-icons cmd
            ed.addCommand('htshortcodes-icons', function() {
                var selectedText = ed.selection.getContent();

                //use global display modal function
                var completeAction = function(values){
                    var selectedText = ed.selection.getContent();
                    var returnText = '';
                    var iconName = '';
                    try{
                        iconName = extractOptionFromSerializedArray(values, 'icon-name'); 
                    } catch (err){
                        //key not in array
                    }  
                    var iconSize = '';
                    try{
                        iconSize = extractOptionFromSerializedArray(values, 'icon-size'); 
                        if(Math.floor(iconSize) == iconSize && $.isNumeric(iconSize)){
                            //valid int
                        } else {
                            alert(htShortcodesPHPData.iconInvalidSize);
                            return false;
                        }
                    } catch (err){
                        //key not in array
                    }  
                    var iconTextColor = extractOptionFromSerializedArray(values, 'text-color');


                    returnText =   '[ht_icon icon="'+ iconName +'" icon_color="'+iconTextColor+'" icon_size="'+iconSize+'" ';
                    returnText +=  getGlobalShortcodeVariables(values);
                    returnText +=  ']';             
                    returnText +=  '[/ht_icon]';
                    
                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }

                var windowTitle = htShortcodesPHPData.shortcodeIconsWindowTitle;
                //helpers
                var entryHelper = htShortcodesPHPData.shortcodeIconsEntryHelper;
                var shortcodeIconsSelectorLabelHelper = htShortcodesPHPData.shortcodeIconsSelectorLabelHelper;
                var shortcodeIconsEntryHelper = htShortcodesPHPData.shortcodeIconsEntryHelper;
                var iconTextColorHelper = htShortcodesPHPData.iconTextColorHelper;
                var iconTextSizeHelper = htShortcodesPHPData.iconTextSizeHelper;

                //values
                var iconTextColor = '#000';
                var iconName= 'fip-icon-block';
                var defaultFontSize = 12;


                var form =  "<div id='ht-shortcodes-icons-entry'>";
                
                //select
                form +=         "<p>" + shortcodeIconsSelectorLabelHelper + "</p>"; 
                form +=         "<select name='icon-name' id='ht-shortcodes-icons-entry-selector'>";    

                //select icon
                for (var key in htShortcodesPHPData.shortcodeIcons) {
                    var label = htShortcodesPHPData.shortcodeIcons[key];
                    var selected = (iconName==label) ? 'selected' : '';
                    form +=  "<option " + selected + ">" + label + "</option>";  
                };

                form +=         "</select>";
                form +=         "<br/>";
                
                //icon color
                form +=         "<label for='text-color'>"+iconTextColorHelper+"</label><br/>";
                form +=         "<input class='ht-sc-color-picker' id='ht-shortcodes-icon-text-color' name='text-color' type='text' value='"+iconTextColor+"'>";
                form +=         "<br/>";

                //icon size
                form +=         "<label for='icon-size'>" + iconTextSizeHelper  + "</label><br />";
                form +=         "<input type='text' name='icon-size' id='ht-shortcodes-icons-size' value='" + defaultFontSize  + "' /><br />";

                form +=         "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);

                //init fontIconPicker andinit wpColorPicker
                jQuery(document).ready(function($) {

                    $('#ht-shortcodes-icons-entry-selector').fontIconPicker({
                        emptyIcon: true,
                    }); // Load with default options
                
                    $('input.ht-sc-color-picker').wpColorPicker();

                });
                
                
            });

        }

    });



    // Register plugin
    tinymce.PluginManager.add( 'hticons', tinymce.plugins.HTIcons );
})();

jQuery(document).ready(function($) {
    
});
