<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Dropcaps Module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Dropcaps' ) ){
	class HT_Shortcodes_Dropcaps {
		static $styles;

		//Constructor
		static function init(){
			/* 	Consider use of http://codex.wordpress.org/Shortcode_API if additional
				front end rendering required */

			//initialize dropcaps styles
			self::$styles = array(
					'default' => __('Default', 'ht-shortcodes'),
				);


			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to load frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );
		}

		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'dropcaps');
			if($load_module){
				//append to styling menu
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'styling' ){
						array_push($submenu['menu'], array('id'=>'dropcaps', 'text'=>__('Drop Caps', 'ht-shortcodes'), 'cmd'=>'htshortcodes-dropcaps'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'dropcaps');
			if($load_module){
				$plugin_array['htdropcaps'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-dropcaps.js';
			}
			return $plugin_array;
		}

		/**
		* Enqueue front end styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'dropcaps');
			if(!$theme_loads_frontend_styles){
				wp_enqueue_style( 'ht-shortcodes-dropcaps-style', plugins_url( 'ht-shortcodes-dropcaps.css', __FILE__ ));
			}
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		public static function ht_shortcodes_filter_mce_css( $mce_css ) {
			$mce_css .= ', ' . plugins_url( 'ht-shortcodes-dropcaps.css', __FILE__ );
			return $mce_css;
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'dropcaps');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-dropcaps-backend-style', plugins_url( 'ht-shortcodes-dropcaps-backend.css', __FILE__ ));
			}
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeDropCapsWindowTitle'] = __('Add new Drop Caps', 'ht-shortcodes');

			$data['shortcodeDropCapsEntryHelper'] = __('Your drop capped letter(s) goes here', 'ht-shortcodes');
			$data['shortcodeDropCapsStyleLabelHelper'] = __('Style', 'ht-shortcodes');
			$data['shortcodeDropCapsEntryLabelHelper'] = __('Text', 'ht-shortcodes');

			$data['shortcodeDropCapsStyles'] = self::$styles;


			return $data;
		}


		
	} //end class HT_Shortcodes_Dropcaps
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Dropcaps' ) ){
	HT_Shortcodes_Dropcaps::init();
}
