(function() {
    tinymce.create('tinymce.plugins.HTDropCaps', {
        HTDropCaps : function(ed, url) {
            //add the htshortcodes-dropcaps cmd
            ed.addCommand('htshortcodes-dropcaps', function() {

                var selectedText = ed.selection.getContent();

                //use global display modal function
                var completeAction = function(values){
                    var selectedText = ed.selection.getContent();
                    var returnText = '';
                    var dropcapsText = extractOptionFromSerializedArray(values, 'dropcaps-text');
                    var dropcapsStyle = extractOptionFromSerializedArray(values, 'dropcaps-style');                    

                    returnText =    '<span class="ht-shortcodes-dropcaps">';
                    returnText +=       dropcapsText;                 
                    returnText +=    '</span>';
                    
                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }

                var windowTitle = htShortcodesPHPData.shortcodeDropCapsWindowTitle;
                //helpers
                var entryHelper = htShortcodesPHPData.shortcodeDropCapsEntryHelper;
                var shortcodeDropCapsStyleLabelHelper = htShortcodesPHPData.shortcodeDropCapsStyleLabelHelper;
                var shortcodeDropCapsEntryLabelHelper = htShortcodesPHPData.shortcodeDropCapsEntryLabelHelper;


                var form =  "<div id='ht-shortcodes-dropcaps-entry'>";
                
                //select
                form +=         "<p>" + shortcodeDropCapsStyleLabelHelper + "</p>"; 
                form +=         "<select name='dropcaps-style' id='ht-shortcodes-dropcaps-entry-style'>";    

                //add styles
                for (var key in htShortcodesPHPData.shortcodeDropCapsStyles) {
                    var label = htShortcodesPHPData.shortcodeDropCapsStyles[key];
                    form +=  "<option value='" + key + "'>" + label + "</option>";  
                };

                form +=         "</select>";
                //mesage area
                form +=         "<p>" + shortcodeDropCapsEntryLabelHelper + "</p>";     
                form +=         "<textarea id='ht-shortcodes-dropcaps-entry-text' name='dropcaps-text' placeholder='" + entryHelper + "'>";
                form +=             selectedText;
                form +=         "</textarea>";

                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);
                hideShortcodesOptionTab();
            });
        }

    });
    // Register plugin
    tinymce.PluginManager.add( 'htdropcaps', tinymce.plugins.HTDropCaps );
})();