<?php
/*
*	Shortcode Module Name: Heroic Shortcodes
*	Description: Buttons Module
*	Author: HeroThemes
*	Version: 1.0
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes_Buttons' ) ){
	class HT_Shortcodes_Buttons {
		static $add_script;

		//Constructor
		static function init(){
			/* 	Consider use of http://codex.wordpress.org/Shortcode_API if additional
				front end rendering required */

			//add shortcode
			add_shortcode( 'ht_button' , array( __CLASS__, 'ht_buttons_shortcode' ) );
			//add the filter to add the module to the shortcodes menu dropdown
			add_filter( 'ht_shortcodes_menu', array( __CLASS__, 'ht_shortcodes_menu_filter' ) );
			//add the filter to load the js module
			add_filter( 'ht_shortcodes_modules', array( __CLASS__, 'ht_shortcodes_plugins_filter' ) );
			//add action to load frontend styles
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_frontend_styles' ) );
			//add action to enqueue backend scripts + styles (do not use for mce editor styles) 
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'ht_shortcodes_backend_scripts_styles' ) ); 
			//add filter to load editor styles
			add_filter( 'mce_css', array( __CLASS__, 'ht_shortcodes_filter_mce_css' ) );
			//add filter to print editor styles and scripts
			add_action( 'wp_footer', array( __CLASS__, 'ht_shortcodes_print_scripts' ) );
			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array ( __CLASS__, 'ht_shortcodes_php_data_filter' ) );
		}

		static function ht_buttons_shortcode($atts, $content = null){
			extract( shortcode_atts( array(
				'font_color' => '#fff',
				'font_color_hover' => '',
				'bg_color' => '#3498db',
				'bg_color_hover' => '',
				'url' => '#',
				'new_window' => 'true',
				'id' => '',
				'class' => '',
				'style' => '',
			), $atts, 'ht_button' ) );

			$new_window_text = ($new_window=='true') ? 'target="_blank"' : '';

			//create a unique classname for this style, note css selectors must begin with a letter
			$button_style_class_name = 'scb' . md5($font_color . $font_color_hover . $bg_color . $bg_color_hover);
			if(empty($bg_color_hover)){
				//lighten the hover color
				$bg_color_hover = HT_Shortcodes_Buttons::adjust_brightness($bg_color, 50);
			}
			
			ob_start();
    		?>
    		<!-- button style <?php echo $button_style_class_name; ?> -->
    		<style>
    			.<?php echo $button_style_class_name; ?>, a.<?php echo $button_style_class_name; ?>{
    				color: <?php echo $font_color; ?>;
    				background-color: <?php echo $bg_color; ?>;
    			}
    			.<?php echo $button_style_class_name; ?>:hover, a.<?php echo $button_style_class_name; ?>:hover{
    				<?php if(!empty($font_color_hover)): ?>
    				color: <?php echo $font_color_hover; ?>;
    				<?php endif; ?>
    				background-color: <?php echo $bg_color_hover; ?>;
    			}
    		</style>
    		<a href="<?php echo $url; ?>" class="ht-shortcodes-button <?php echo $button_style_class_name; ?> <?php echo $class; ?>" id="<?php echo $id; ?>" style="<?php echo $style; ?>" <?php echo $new_window_text; ?>>
    		<?php echo $content; ?></a>
    		<?php
			return ob_get_clean();
		}

		static function adjust_brightness($hex, $steps) {
			//credit - http://stackoverflow.com/users/1034002/torkil-johnsen
		    // Steps should be between -255 and 255. Negative = darker, positive = lighter
		    $steps = max(-255, min(255, $steps));

		    // Format the hex color string
		    $hex = str_replace('#', '', $hex);
		    if (strlen($hex) == 3) {
		        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
		    }

		    // Get decimal values
		    $r = hexdec(substr($hex,0,2));
		    $g = hexdec(substr($hex,2,2));
		    $b = hexdec(substr($hex,4,2));

		    // Adjust number of steps and keep it inside 0 to 255
		    $r = max(0,min(255,$r + $steps));
		    $g = max(0,min(255,$g + $steps));  
		    $b = max(0,min(255,$b + $steps));

		    $r_hex = str_pad(dechex($r), 2, '0', STR_PAD_LEFT);
		    $g_hex = str_pad(dechex($g), 2, '0', STR_PAD_LEFT);
		    $b_hex = str_pad(dechex($b), 2, '0', STR_PAD_LEFT);

		    return '#'.$r_hex.$g_hex.$b_hex;
		}

		/**
		* Shortcodes menu filter
		* @param (Array) $menu The raw menu
		* @param (Array) Filtered menu
		*/
		static function ht_shortcodes_menu_filter($menu){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'buttons');
			if($load_module){
				//append to styling menu			
				foreach ($menu as $key => &$submenu) {
					if( $submenu['id'] == 'styling' ){
						array_push($submenu['menu'], array('id'=>'buttons', 'text'=>__('Button', 'ht-shortcodes'), 'cmd'=>'htshortcodes-buttons'));
					}
				}
			}
			return $menu;
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		static function ht_shortcodes_plugins_filter($plugin_array){
			$load_module = apply_filters('ht-shortcodes-load-module', true, 'buttons');
			if($load_module){
				$plugin_array['htbuttons'] = plugin_dir_url( __FILE__ ).'ht-shortcodes-buttons-backend.js';
				//uses wp-color-picker, safe to use without dependancy as mce is late loaded
				wp_enqueue_style( 'wp-color-picker' );
			}
			return $plugin_array;
		}

		/**
		* Enqueue front end styles
		*/
		static function ht_shortcodes_frontend_styles(){
			//check theme support for shortocde css for this module
			$theme_loads_frontend_styles = apply_filters('ht-shortcodes-css', false, 'buttons');
			if(!$theme_loads_frontend_styles){
				wp_enqueue_style( 'ht-shortcodes-buttons-frontend-style', plugins_url( 'ht-shortcodes-buttons-frontend.css', __FILE__ ));
			}
		}

		/**
		* Enqueue backend scripts and styles
		*/
		static function ht_shortcodes_backend_scripts_styles(){
			$load_backend_scripts_and_styles = apply_filters('ht-shortcodes-backend-ss', true, 'buttons');
			if($load_backend_scripts_and_styles){
				wp_enqueue_style( 'ht-shortcodes-buttons-backend-style', plugins_url( 'ht-shortcodes-buttons-backend.css', __FILE__ ));
			}
		}

		/**
		* TinyMCE styles filter - append editor styles using this filter
		* @param (String) $mce_css The raw mce css string
		* @param (String) Filtered mce css string
		*/
		public static function ht_shortcodes_filter_mce_css( $mce_css ) {
			//na
			return $mce_css;
		}

		/**
		* Print front end scripts if shortcodes are used
		*/
		static function ht_shortcodes_print_scripts() {
			if ( ! self::$add_script )
				return;

			wp_print_styles('ht-shortcodes-buttons-frontend-style');
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeButtonWindowTitle'] = __('Add Button', 'ht-shortcodes');
			$data['shortcodeButtonTextHelper'] = __('Enter text here', 'ht-shortcodes');
			$data['shortcodeButtonURLHelper'] = __('Enter url here', 'ht-shortcodes');
			$data['shortcodeButtonBgColorHelper'] = __('Background Color', 'ht-shortcodes');
			$data['shortcodeButtonTextColorHelper'] = __('Text Color', 'ht-shortcodes');
			$data['shortcodeButtonNewWindowHelper'] = __('New Window', 'ht-shortcodes');

			return $data;
		}


		
	} //end class HT_Shortcodes_Buttons
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes_Buttons' ) ){
	HT_Shortcodes_Buttons::init();
}


