(function() {
    tinymce.create('tinymce.plugins.HTAccordion', {
        HTAccordion : function(ed, url) {
            //add the htshortcodes-buttons cmd
            ed.addCommand('htshortcodes-accordion', function() {
                var selectedText = ed.selection.getContent();
                //use global display modal function
                var completeAction = function(values){
                    console.log(values);
                    
                    var returnText = '';
                    var sectionCount = extractOptionFromSerializedArray(values, 'section-count');
                    var sectionCountInt = parseInt(sectionCount);
                    
                    var sections = { heads : [], contents : [] } ;

                    //array position tracker
                    var x = 1;

                    //beware - this functionality relies on the values from the arraySerialization of the form to be ordered and not poulted 
                    //(eg by some sort of form injection)

                    //populate sections
                    for (var i = 1; i < values.length; i=i+1) {
                        try{
                            //head and content check
                            if(values[i].name=="section-head" && values[i+1].name=="section-content"){
                                //content head
                                var head = values[i].value;
                                //content value
                                var content = values[i+1].value;
                                sections.heads[x] = head;
                                sections.contents[x] = content;
                                //increment array position tracker
                                x = x+1;
                            }
                            

                        } catch( err ){
                            console.log('error');
                        }
                        

                    }

                    returnText = '[ht_accordion sections="' + sectionCount+'" ';

                    for (var i = 1; i < sectionCountInt+1; i++) {

                        returnText += ' section_head_' + i + '=\'' + sections.heads[i] + '\' ';
                        returnText += ' section_content_' + i + '=\'' + sections.contents[i] + '\' ';

                    }

                    returnText += getGlobalShortcodeVariables(values);

                    returnText += ']';
                    ed.execCommand('mceInsertContent', 0, returnText);
                    
                }


                //helpers
                var sectionHeadHelper = "Section Head";
                var sectionContentHelper = "Section Content";

                var defaultNoOfSections = 3;
                var windowTitle = htShortcodesPHPData.shortcodeAccordionWindowTitle;
                var form =  "<div id='ht-shortcodes-accordion-entry'>";
                form +=         "<input id='ht-shortcodes-accordion-sections-count' name='section-count' type='text' value='"+defaultNoOfSections+"'>";
                form +=             "<ul id='ht-shortcodes-accordion-sections'>";
                for (var i = 1; i < defaultNoOfSections+1; i++) {
                    form += getSectionLiCode();        
                };
                form +=             "</ul>";
                form +=     "</div>";
                var validation = jQuery('#ht-shortcodes-modal-form');
                displayModal(form, completeAction, validation, windowTitle);

                updateSectionIDs();
                initializeButtons();


                function removeAccordionSection(idToRemove){
                    console.log('#ht-shortcodes-accordion-section-'+idToRemove);
                    jQuery('li.ht-shortcodes-accordion-section').each(function(){
                         var section = jQuery(this);
                         var sectionID = section.attr('data-id');
                         console.log('sectionID->'+sectionID);
                         if(sectionID == idToRemove){
                            console.log('removing->'+sectionID);
                            section.slideUp('slow', function(){
                                section.remove();
                                updateSectionIDs();
                            });
                            
                         }

                    });

                    
                }

                function initializeButtons(){
                    jQuery('a.ht-shortcodes-remove-accordion-section').each(function(){

                        var removeBtn = jQuery(this);
                        //remove prior handlers
                        removeBtn.off();
                        
                        removeBtn.click(function( event ){
                            event.preventDefault();
                            target = jQuery(event.target);
                            var idToRemove = target.parent('li.ht-shortcodes-accordion-section').attr('data-id');
                            console.log('click remove');
                            console.log(idToRemove);
                            removeAccordionSection(idToRemove);
                        });
                    });
                    jQuery('a.ht-shortcodes-add-accordion-section').each(function(){
                        var addBtn = jQuery(this);
                        //remove prior handlers
                        addBtn.off();
                        addBtn.click(function( event ){
                            event.preventDefault();
                            target = jQuery(event.target);
                            var parentSection = target.parent('li.ht-shortcodes-accordion-section');
                            var idToRemove = parentSection.attr('data-id');
                            parentSection.after(getSectionLiCode()).show('slow');
                            updateSectionIDs();
                            initializeButtons();
                        });
                    });
                }

                function onFocusActions(){
                    jQuery('input.ht-shortcodes-accordion-head, textarea.ht-shortcodes-accordion-content').each(function(){

                        var input = jQuery(this);

                        input.click(function() {
                            jQuery(this).select();
                        });

                        input.focus(function() {
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);
                        });


                    });
                }

                onFocusActions();

                function initialFocusAction(){
                    jQuery('input.ht-shortcodes-accordion-head, textarea.ht-shortcodes-accordion-content').first().each(function(){
                            var targetInput = jQuery(this);
                            window.setTimeout (function(){ 
                               targetInput.select(); 
                            },100);

                    });
                }

                initialFocusAction();





                //get the li code for a section
                function getSectionLiCode(){
                    var li = "<li class='ht-shortcodes-accordion-section' data-id='0'>";
                    li +=  "<input class='ht-shortcodes-accordion-head' name='section-head' type='text' value='"+sectionHeadHelper+"'>";
                    li +=  "<textarea cols='10' class='ht-shortcodes-accordion-content' name='section-content'>"+sectionContentHelper+"</textarea>";
                    li +=  "<a href='' class='ht-shortcodes-remove-accordion-section'>"+"-"+"<span class='ht-tooltip'>Remove Section</span></a> ";
                    li +=  "<a href='' class='ht-shortcodes-add-accordion-section'>"+"+"+"<span class='ht-tooltip'>Add Section</span></a>";
                    li +=  "</li>";
                    return li;

                }

                function updateSectionIDs(){
                    //tracker counter
                    var i = 1;
                    jQuery('li.ht-shortcodes-accordion-section').each(function(){
                         var section = jQuery(this);
                         section.attr('data-id', i);
                         i++;
                    });
                    //reset the no of sections
                    setNoSections(i-1);
                }

                function setNoSections(count){
                    jQuery('#ht-shortcodes-accordion-sections-count').val(count);
                }
                
            });
        }

    });



    // Register plugin
    tinymce.PluginManager.add( 'htaccordion', tinymce.plugins.HTAccordion );
})();
