(function() {
    tinymce.create('tinymce.plugins.HTShortcodes', {
        /**
         * Initializes the plugin, this will be executed after the plugin has been created.
         * This call is done before the editor instance has finished it's initialization so use the onInit event
         * of the editor instance to intercept that event.
         *
         * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.
         * @param {string} url Absolute URL to where the plugin is located.
         */
        init : function(ed, url) {

            var menuTest = ht_shortcodes_menu;
            //fix the menu by converting the cmds to functions
            convertCMDsToOnClicks(menuTest);

            ed.addCommand('test0', function() {
                ed.windowManager.alert('Just hello');
            });


            ed.addCommand('test1', function() {
                ed.windowManager.alert('hello1');
            });

            ed.addCommand('test2', function() {
                ed.windowManager.alert('hello2');
            });

            ed.addCommand('test3', function() {
                ed.windowManager.alert('hello3');
            });


            ed.addButton('ht-shortcodes-button', {
                title : 'Heroic Shortcodes',
                type: 'menubutton',
                icon : 'icon dashicons-shield-alt',
                menu : menuTest,
            });


        },

        /**
         * Creates control instances based in the incomming name. This method is normally not
         * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons
         * but you sometimes need to create more complex controls like listboxes, split buttons etc then this
         * method can be used to create those.
         *
         * @param {String} n Name of the control to create.
         * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.
         * @return {tinymce.ui.Control} New control instance or null if no control was created.
         */
        createControl : function(n, cm) {
            return null;
        },

        /**
         * Returns information about the plugin as a name/value array.
         * The current keys are longname, author, authorurl, infourl and version.
         *
         * @return {Object} Name/value array containing information about the plugin.
         */
        getInfo : function() {
            return {
                longname : 'Heroic Shortcodes',
                author : 'HeroThemes',
                authorurl : 'http://herothemes.com',
                infourl : 'http://herothemes.com',
                version : "0.1"
            };
        }


    });

    function convertCMDsToOnClicks(arrayToFix){
        if(arrayToFix instanceof Array){
            var arrayLength = arrayToFix.length;
            for (var i = 0; i < arrayLength; i++) {
                convertCMDsToOnClicks(arrayToFix[i]);
            }
        } else {
            if(arrayToFix.hasOwnProperty('menu')){
                convertCMDsToOnClicks(arrayToFix.menu);
            }
            if(arrayToFix.hasOwnProperty('cmd')){
                var cmd = arrayToFix.cmd;
                arrayToFix.onclick = (function(){
                    console.log(cmd);
                    tinyMCE.activeEditor.execCommand(cmd);});
            }
        }
    }



    // Register plugin
    tinymce.PluginManager.add( 'htshortcodes', tinymce.plugins.HTShortcodes );


})();
