//Validate is from JQuery Validation library http://jqueryvalidation.org/validate/
function displayModal(form, complete, validation, title){

    //remove any old dialogs
    jQuery("#ht-shortcodes-modal-form").dialog('destroy').remove();

    var shortcodeIDEntryPlaceholder = htShortcodesPHPData.shortcodeIDEntryPlaceholder;
    var shortcodeClassEntryPlaceholder = htShortcodesPHPData.shortcodeClassEntryPlaceholder;
    var shortcodeInlineStyleEntryPlaceholder = htShortcodesPHPData.shortcodeInlineStyleEntryPlaceholder;

    var globalOptions = "<div id='ht-shortcodes-toggle-entry'>"+
                            "<input id='ht-shortcodes-global-id' name='id' type='text' placeholder='"+shortcodeIDEntryPlaceholder+"'>"+
                            "<input id='ht-shortcodes-global-class' name='class' type='text' placeholder='"+shortcodeClassEntryPlaceholder+"'>"+
                            "<textarea cols='10' id='ht-shortcodes-global-inline-style' name='style' placeholder='"+shortcodeInlineStyleEntryPlaceholder+"'></textarea>"+
                        "</div>";

    var shortcodeDialog = jQuery("<form id='ht-shortcodes-modal-form' action='#'>" + 
                        "<div id='ht-shortcodes-modal-form-tabs'>" +
                            "<ul>" +
                                "<li><a href='#ht-sc-content-tab'>Content</a></li>" +
                                "<li><a href='#ht-sc-options-tab'>Options</a></li>" +                                
                            "</ul>" +
                            "<div id='ht-sc-options-tab'>" +
                                globalOptions +
                            "</div>" + 
                            "<div id='ht-sc-content-tab'>" +
                                form +
                            "</div>" +
                            
                        "</div>" +
                        "</form>").dialog({
                                    dialogClass: 'ht-shortcodes-ui-dialog',
                                    width: 400,
                                    buttons: {
                                        Cancel : function(){
                                            shortcodeDialog.dialog('destroy').remove();
                                        },
                                        OK : function(){
                                            validation.submitHandler(this);
                                           
                                        }
                                    },
                                    title: title
                                });

    //init tabs
    jQuery('#ht-shortcodes-modal-form-tabs').tabs();
    //set active tab
    jQuery('#ht-shortcodes-modal-form-tabs').tabs( "option", "active", 0 );

    //add our own custom class to the ui-dialog
    //jQuery('#ht-shortcodes-modal-form').parent('.ui-dialog').addClass('ht-shortcodes-ui-dialog');

    validation.submitHandler = function(form){
       
        var modalForm = jQuery("form#ht-shortcodes-modal-form");
        var formValues = modalForm.serializeArray();

        modalForm.children().each(function() {
            if(this.type === "checkbox"){
                var checked = jQuery(this).is(":checked");
                if(checked){
                    for(var i = 0; i < formValues.length; i++){
                        if(formValues[i].name === this.id){
                            formValues[i].value = true;
                            break;
                        }
                    }
                }
                else {
                    formValues.push({name: this.id, value: false});
                }

            }
        });

        shortcodeDialog.dialog('destroy').remove();

        complete(formValues);

        console.log('Submit');

       
        jQuery.ajax({
            url : ajaxurl,
            data : {
                    'action': 'save_ht_shortcode_options',
                    'form' : formValues 
            },
            success : function(data, textStatus, jqXHR){
            },
            type : "POST"
        });
    };

    //jQuery("form#ht-shortcodes-modal-form").validate(validation);
}
//get get option function, similar to WordPress getOption
function getOption(option){
    var value = htShortcodesPHPData[option];
    return typeof value !== "undefined" ? htShortcodesPHPData[option] : "";
}

// Extract an option from an array serialized by jQuery
function extractOptionFromSerializedArray(array, key){
    for(var i = 0; i < array.length; i++){
        if(array[i].name === key){
            return array[i].value;
        }
    }

    throw "Key not in array->"+key;
}

//return global shortcode variables
function getGlobalShortcodeVariables(values){
    var returnString = "";
    var id = extractOptionFromSerializedArray(values, 'id');
    returnString += " id=&quot;" + id + "&quot; ";
    var className = extractOptionFromSerializedArray(values, 'class');
    returnString += " class=&quot;" + className + "&quot; ";
    var style = extractOptionFromSerializedArray(values, 'style');
    returnString += " style=&quot;" + style + "&quot; ";
    
    return returnString;
}

//hide options tab
function hideShortcodesOptionTab(){
    jQuery('#ht-shortcodes-modal-form-tabs').tabs( "disable", "#ht-sc-options-tab" );
}
