<?php
/*
*	Plugin Name: Heroic Shortcodes
*	Plugin URI:  http://wordpress.org/plugins/hero-themes-shortcodes/
*	Description: Shortcodes for HeroThemes Products
*	Author: HeroThemes
*	Version: 1.1.5
*	Author URI: http://www.herothemes.com/
*	Text Domain: ht-shortcodes
*/


if( !class_exists( 'HT_Shortcodes' ) ){
	class HT_Shortcodes {
		//Constructor
		function __construct(){
			load_plugin_textdomain('ht-shortcodes', false, basename( dirname( __FILE__ ) ) . '/languages' );

			add_action( 'init', array( $this, 'ht_shortcodes_buttons' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'ht_shortcodes_enqueue_scripts_and_styles' ) );
			add_action( 'init', array( $this, 'ht_shortcode_load_modules' ) );
			add_action( 'wp_ajax_save_ht_shortcode_options', array( $this, 'ht_shortcodes_save_options_ajax' ) );

			//i18n data filter
			add_filter( 'ht_shortcodes_php_data', array( __CLASS__, 'ht_shortcodes_php_data_filter' ) );

			//frontend css filter
			add_filter( 'ht-shortcodes-css', array( $this, 'ht_shortcodes_frontend_css_display_filter' ), 10, 2 );

			//load module filter
			add_filter( 'ht-shortcodes-load-module', array( $this, 'ht_shortcodes_load_module_filter' ), 10, 2 );

			//backend scripts and styles filter
			add_filter( 'ht-shortcodes-backend-ss', array( $this, 'ht_shortcodes_backend_scripts_and_styles_filter' ), 10, 2 );
		}


		/**
		* Register MCE buttons
		*/
		function ht_shortcodes_buttons() {
		    add_filter( 'mce_external_plugins', array( $this, 'ht_shortcodes_add_buttons' ) );
		    add_filter( 'mce_buttons', array( $this, 'ht_shortcodes_register_buttons' ) );
		}

		/**
		* TinyMCE plugin filter - append shortcode plugin
		* @param (Array) $plugin_array The raw plugin array
		* @param (Array) Filtered plugin array
		*/
		function ht_shortcodes_add_buttons( $plugin_array ) {
			$screen = function_exists('get_current_screen') ? get_current_screen() : null;
			if(!$screen){
				return;
			}
			if( $screen && ( 'post' != $screen->base && ( $screen->base != 'term' && $screen->taxonomy != 'ht_kb_category' ) ) ){
				//bail early if not on an edit screen
				return;
			}
		    $plugin_array['htshortcodes'] = plugin_dir_url( __FILE__ ).'js/ht-shortcodes-script.js';
		    $plugin_array = apply_filters( 'ht_shortcodes_modules', $plugin_array );
		    return $plugin_array;
		}

		/**
		* TinyMCE buttons filter - add ht-shortcodes button
		* @param (Array) $buttons The raw buttons array
		* @param (Array) Filtered buttons array
		*/
		function ht_shortcodes_register_buttons( $buttons ) {
		    array_push( $buttons, 'ht-shortcodes-button' ); 
		    return $buttons;
		}

		/**
		* AJAX function to save user options
		*/
		function ht_shortcodes_save_options_ajax(){
			//@todo - check ajax?
			if(!isset($_POST['form'])){
				//no form data
				return;
			}
				
			//get the current user
			$current_user = wp_get_current_user();

			//populate form data
			$form_data = is_array($_POST['form']) ? $_POST['form'] : array();

			//loop over the data to save the values
		    foreach($form_data as $key => $value){
		    	if( isset( $value['name'] ) && isset( $value['value']) ){
		    		$name = $value['name'];
		    		$val = $value['value'];
		    		update_user_meta($current_user->ID, "ht-shortcodes-" . $name, $val);
		    	}
		        
		    }
		}

		/**
		* Enqueue the required scripts and styles (only in admin)
		*/
		function ht_shortcodes_enqueue_scripts_and_styles() {

			$screen = get_current_screen();
			if( $screen && ( 'post' != $screen->base && ( $screen->base != 'term' && $screen->taxonomy != 'ht_kb_category' ) ) ){
				//bail early if not on an edit screen
				return;
			} 

		    //set up initial menu
			$menu = array(
		    			array( 'id' => 'layout',   'text' => 'Layout',   'menu' => array(  ) ),
		    			array( 'id' => 'styling',  'text' => 'Styling',  'menu' => array(  ) ),
		    			array( 'id' => 'elements', 'text' => 'Elements', 'menu' => array(  ) ),
		    		);

			//apply filters for modules to add their menu items
			$menu = apply_filters( 'ht_shortcodes_menu', $menu );

			//redact any menu items that are not populated at this point
			foreach ($menu as $key => $categories) {
				//get the menu items
				$items = $categories['menu'];
				$count = count($items);
				if(0==$count){
					//remove
					unset($menu[$key]);
					
				}
			}
			//reindex
			$menu = array_values($menu);

			//enqueue dummy script required to ensure the localization appears on the front end
		    wp_enqueue_script( 'ht-shortcodes-dummy', plugins_url( 'js/ht-shortcodes-dummy.js', __FILE__ ), array( 'jquery' ) );
		    wp_localize_script( 'ht-shortcodes-dummy', 'ht_shortcodes_menu', $menu );

			//jQuery UI is used by the Modal
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_style('wp-jquery-ui-dialog');

			wp_enqueue_script('jquery-ui-button');
			wp_enqueue_style('wp-jquery-ui-button');

			wp_enqueue_script('jquery-ui-tabs');
			//load the style for jquery ui
			wp_enqueue_style('wp-jquery-ui-tabs', plugins_url( 'lib/jquery-ui/jquery-ui.css', __FILE__ ), false, '1.8.21-base' );
			

			//jQuery validation library, used by the Modal
			wp_enqueue_script( 'jquery-validate', plugins_url( 'lib/jquery-validate/jquery.validate.min.js', __FILE__ ), array( 'jquery' ),  '1.13.0');

			//ht-shortcodes-admin.js contains functions shared by different modules but only used in the admin panel.
			wp_enqueue_script('ht-shortcodes-admin', plugins_url( 'js/ht-shortcodes-admin.js', __FILE__ ), array( 'jquery', 'jquery-validate'));
			//create data
			$data = array();
			//pass through filters to load data
			$data = apply_filters( 'ht_shortcodes_php_data', $data);
			wp_localize_script('ht-shortcodes-admin', 'htShortcodesPHPData', $data);

			//enqueue generic styles
		    wp_enqueue_style( 'ht-shortcodes-script-style', plugins_url( 'css/ht-shortcodes-style.css', __FILE__ ) );

		}

		/**
		* Load all the submodules
		*/
		function ht_shortcode_load_modules(){
			$directory = new RecursiveDirectoryIterator( plugin_dir_path( __FILE__ ) . 'modules' );
			$iterator = new RecursiveIteratorIterator( $directory );
			//only iterate over php files
			$regex_iterator = new RegexIterator( $iterator, '/^.+\.php$/i', RecursiveRegexIterator::GET_MATCH );
			foreach ( $regex_iterator as $key => $file ) {
				if( array_key_exists( 0, $file ) ){
					$include_file = $file[0];
					include_once( $include_file );
				}

			}
		}

		/**
		* Filter for frontend css display
		* @param (Boolean) $theme_load_frontend_styles Whether the module is supported by the theme
		* @param (String) $module The module name 
		* @return (Boolean) Whether the module is supported by the theme
		*/
		function ht_shortcodes_frontend_css_display_filter($theme_load_frontend_styles=false, $module=''){
			//knowall, always loads it's own frontend styles
			return true;
			/*
			if(isset($module)){
				$ht_shortcodes_theme_load_frontend_styles = get_theme_support( 'ht-shortcodes' );
				//interrogate array
				if( is_array($ht_shortcodes_theme_load_frontend_styles) && in_array($module, $ht_shortcodes_theme_load_frontend_styles)){
					//if the module is theme_load_frontend_styles in the theme
					$theme_load_frontend_styles = true;
				}
			}
			//base case
			return $theme_load_frontend_styles;
			*/
		}

		/**
		* Filter for load module based on theme support
		* @param (Boolean) $supported Whether the module is supported by the theme
		* @param (String) $module The module name 
		* @return (Boolean) Whether the theme wants the module loaded
		*/
		function ht_shortcodes_load_module_filter($load=true, $module=''){
			if(isset($module)){
				$ht_shortcodes_supported = get_theme_support( 'ht-shortcodes' );
				//interrogate array
				if( is_array($ht_shortcodes_supported) ){
					//if the theme declares support for ht-shortcodes
					if( in_array($module, $ht_shortcodes_supported) ){
						//and the module, load module
						$load = true;
					} else {
						//else do not load module
						$load = false;
					}
				}
			}
			//base case
			return $load;
		}


		/**
		* Filter for backend scripts and style load
		* @param (Boolean) $supported Whether the module is supported by the theme
		* @param (String) $module The module name 
		* @return (Boolean) Whether the theme wants the module loaded
		*/
		function ht_shortcodes_backend_scripts_and_styles_filter($load=true, $module=''){
			//only run on admin
			if(is_admin()){
				$screen = get_current_screen();
				//only load on edit screen
				if('edit'==$screen->base){
					if(isset($module)){
						$ht_shortcodes_supported = get_theme_support( 'ht-shortcodes' );
						//interrogate array
						if( is_array($ht_shortcodes_supported) ){
							//if the theme declares support for ht-shortcodes
							if( in_array($module, $ht_shortcodes_supported) ){
								//and the module, load module
								$load = true;
							} else {
								//else do not load module
								$load = false;
							}
						}
					}				
				} else {
					//not on edit screen
					$load = false;
				}
			} else {
				//not in admin
				$load = false;
			}
			
			//base case
			return $load;
		}


		/**
		* static function to extract a value from an array serialized by jquery.serializeArray
		* items will be contained as name-values pairs
		* @param (Array) $array
		* @param (String) $key 
		* @return (Mixed) The key value
		*/
		public static function extract_value_from_serialized_array($array, $key){
			foreach ($array as $x => $item) {
				if(isset($item['name']) && $item['name']==$key){
					return $item['value'];
				}
			}

			return null;
		}

		/**
		* Custom data filter for 18n 
		* @param (Array) $menu The raw data array
		* @return (Array) Filtered data array
		*/
		static function ht_shortcodes_php_data_filter($data){
			$data['shortcodeIDEntryPlaceholder'] = __('ID', 'ht-shortcodes');
			$data['shortcodeClassEntryPlaceholder'] = __('Class Name', 'ht-shortcodes');
			$data['shortcodeInlineStyleEntryPlaceholder'] = __('Inline Styles', 'ht-shortcodes');

			return $data;
		}


	} //end class HT_Shortcodes
}//end class exists test

//run the plugin
if( class_exists( 'HT_Shortcodes' ) ){
	$ht_shortcodes_init = new HT_Shortcodes();
}
