<?php

/* Load theme stylesheets */
function ht_theme_style() {
	// Load parent style
	wp_enqueue_style( 'ht-theme-style', get_template_directory_uri() . '/css/style.css' );
	// Load child style
	wp_enqueue_style( 'ht-childtheme-style', get_stylesheet_uri(), array('ht-theme-style') );
}
add_action( 'wp_enqueue_scripts', 'ht_theme_style' );


/* Insert custom functions here */

// Add 3rd party stylesheets
wp_enqueue_style( 'uikit', get_stylesheet_directory_uri() . '/lib/uikit/css/uikit.min.css', '', '3.6.18' );
wp_enqueue_style( 'font-awesome-pro', get_stylesheet_directory_uri() . '/lib/fontawesome-pro/css/all.min.css', '', '5.15.2' );

// Add 3rd party scripts
wp_enqueue_script( 'uikit', ( get_stylesheet_directory_uri() . '/lib/uikit/js/uikit.min.js' ), array( 'jquery' ), '3.6.18', 'true' );

function data_category_icons(
	string $slug = null
) {

	// Set default icon
	$icon_default = 'question';

	// Assign icons to use for each category
	$icons = array(
		'getting-started'    => 'cogs',
		'account-management' => 'user-alt',
		'projects'           => 'project-diagram',
		'dashboard'          => 'analytics',
		'nps'                => 'star-half',
		'enps'               => 'star-half',
		'csat'               => 'star-half',
		'ces'                => 'star-half',
		'teams'              => 'user-friends',
		'billing'            => 'receipt',
		'privacy'            => 'shield-alt',
		'developer-tools'    => 'code'
	);

	// Get icon for category
	$icon = (string) (isset($icons[$slug]) ? $icons[$slug] : $icon_default);

	return $icon;
}


remove_filter ('the_content', 'wpautop');







add_filter( 'body_class','my_body_classes' );
function my_body_classes( $classes ) {

    $classes[] = 'customize-support';

    return $classes;

}