<?php
/**
* Knowledge Base API
*/

//exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

if( !class_exists( 'HT_Knoweldge_Base_API' ) ){
    class HT_Knoweldge_Base_API {

        //constructor
        function __construct() {
            //kb category
            add_action( 'rest_api_init', array( $this, 'ht_kb_category_rest_api_add_meta' ) );
        }


        /**
         * extend the wp-api to add display content field
         */
        function ht_kb_category_rest_api_add_meta() {

            $ht_kb_category_meta_fields = array (
                                    'term_order',
                                    'default_preview',
                                    'meta_image',
                                    'meta_image',
                                    'attachment_thumb',
                                    'thumbnail_url',
                                    'meta_svg',
                                    'meta_svg_color',
                                    'custom_link',
                                    'meta_color',
                                    'restrict_access',
                                );

            $ht_kb_category_meta_fields = apply_filters( 'ht_kb_category_meta_fields', $ht_kb_category_meta_fields );

            foreach ($ht_kb_category_meta_fields as $key => $field) {
                register_rest_field(
                    'ht_kb_category',
                    $field,
                    array(
                        'get_callback'    => array( $this, 'ht_kb_category_get_meta' ),
                        'update_callback' => null,
                        'schema'          => null,
                    )
                );
            }


            //category thumbnail
            register_rest_field(
                    'ht_kb_category',
                    'category_thumbnail',
                    array(
                        'get_callback'    => array( $this, 'ht_kb_category_get_icon_thumb' ),
                        'update_callback' => null,
                        'schema'          => null,
                    )
                );

            
        }

        function ht_kb_category_get_meta( $term, $field_name, $request ){
            $meta_value =  get_term_meta( $term['id'], $field_name, true );
            return apply_filters( 'ht_kb_category_get_meta_' . $field_name, $meta_value ); 
        }

        function ht_kb_category_get_icon_thumb( $term, $field_name, $request ){
            ob_start();
            hkb_category_thumb_img($term['id'] );
            $thumb = ob_get_clean();
            return $thumb;
        }

        

    }
}

//run the module
if( class_exists( 'HT_Knoweldge_Base_API' ) ){
    $ht_kb_stubs_init = new HT_Knoweldge_Base_API();
}