//# sourceMappingURL=ht-shortcodes-messages-block-source.jsx.map
/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

 //import './ht-shortcodes-messages-block-style.css';

const { __ } = wp.i18n; // Import __() from wp.i18n
const { registerBlockType } = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText,
} = wp.editor;

const {
	Panel,
	PanelBody,
	PanelRow,
	RangeControl,
	SelectControl,
	TextControl,
    CheckboxControl,
    ColorPicker,
} = wp.components;

const { Fragment } = wp.element;

const blockIcon = (
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" strokeWidth="2">
                <g>
                    <path fill="none" stroke="#555d66" strokeLinecap="square" strokeMiterlimit="10" d="M2 1h20v22H2z"/>
                    <path fill="none" stroke="#555d66" strokeLinecap="square" strokeMiterlimit="10" d="M12 7v7"/>
                    <circle stroke="none" fill="#555d66" cx="12" cy="18" r="1"/>
                </g>
            </svg>
        );

/**
 * Register Block
 */
registerBlockType( 'ht-blocks/messages', {
	title: __( 'Heroic Blocks - Messages' ), 
	description: __( 'Add a message callout' ), 
	icon: {
            src: blockIcon,
            foreground: 'auto',
        },
	category: 'heroic-blocks', 
	keywords: [
		__( 'Heroic Blocks' ),
		__( 'Message' ),
		__( 'messages' ),
	],

    attributes: {
        content: {
            source: 'html',
            selector: 'p',
        },
        showIcon: {
            type: 'boolean',
            default: true
        },
        showIconClassName: {
            type: 'string',
            default: 'withicon'
        },
        baseClassName: {
            type: 'string',
            default: 'wp-block-hb-message'
        },        
        backgroundColor: {
            type: 'string',
            default: '#f00'
        },
        textColor: {
            type: 'string',
            default: '#000'
        }
    },

    styles: [
        { name: 'success', label: __( 'Success' ), isDefault: true },
        { name: 'alert', label: __( 'Alert' ) },
        { name: 'danger', label: __( 'Danger' ) },
        { name: 'info', label: __( 'Information' ) },
    ],

    supports: {
        align: true,
    },

    edit: function( {className, attributes, setAttributes} ) {
        const { content, showIcon, showIconClassName, baseClassName, backgroundColor, textColor } = attributes;

        const onChangeContent = (newContent) => {
            setAttributes( { content: newContent } );
        }

        const onChangeShowIcon = (newShowIcon) => {
            setAttributes( { showIcon: newShowIcon } );

            console.log('newShowIcon->' + newShowIcon);
            setAttributes( { showIconClassName: newShowIcon ? 'withicon' : 'noicon' } );
            console.log('showIconClassName->' + showIconClassName);
        }

        const onChangeCompleteBackgroundColor = (color) => {
            console.log('newBackroundColor->' + color.hex );
            setAttributes( { backgroundColor: color.hex  } );
        }

        return (
            <Fragment>
            	<InspectorControls
            		key='inspector'
            	>
            		<PanelBody
            			title={ __( 'Options' ) }
            			className='heroic-blocks-messages-panel-body'
            			initialOpen={ false }
            		>
            			<div className='ht-blocks-messages-block-control'>{ __( 'Control this Messages Block' ) }</div>
                        <CheckboxControl
                            label={ __( 'Show Icon' ) }
                            checked={ showIcon }
                            onChange={ onChangeShowIcon }
                        />
            		</PanelBody>
            	</InspectorControls>
                <RichText
                    className={ className + ' ' + baseClassName + ' ' + baseClassName + '--' + showIconClassName }
                    tagName='p'
                    onChange={ onChangeContent }
                    placeholder={ __( 'This will be the message' ) }
                    keepPlaceholderOnFocus={ true }
                    //style={ 'color:' + textColor + ';background-color:'+ backgroundColor + ';' } 
                    value={ content }
                />
            </Fragment>
        );
    },



    save: function( {  attributes  } ) {
        const { content, showIcon, showIconClassName, baseClassName, backgroundColor, textColor } = attributes;
        console.log('base');


        //backgroundColor
        //textColor

     

        //console.log(baseClassName);

        return (
                <RichText.Content 
                    className={ baseClassName + ' ' + baseClassName + '--' + showIconClassName } 
                    tagName='p' 
                    //style={ 'color:' + textColor + ';background-color:'+ backgroundColor + ';' } 
                    value={ content } 
                />
        );

    },

} );
