const {
  __
} = wp.i18n;
const {
  useEffect
} = wp.element;
const {
  registerBlockType
} = wp.blocks;
const {
  RichText,
  InspectorControls,
  ColorPalette,
  AlignmentToolbar,
  BlockControls
} = wp.blockEditor || wp.editor;
const {
  IconButton,
  Dropdown,
  PanelBody,
  RangeControl,
  SelectControl
} = wp.components;
const {
  withState,
  compose
} = wp.compose;
const {
  withSelect
} = wp.data;
registerBlockType('ht-blocks/list', {
  title: __('Heroic Blocks - List'),
  //@todo - replace with custom icon
  icon: 'editor-ol',
  category: 'heroic-blocks',
  attributes: {
    blockID: {
      type: 'string',
      default: ''
    },
    list: {
      type: 'text' //todo default should have placeholders not items
      //default: '<li>Item 1</li><li>Item 2</li><li>Item 3</li>'		

    },
    iconColor: {
      type: 'string',
      default: '#000000'
    },
    iconRound: {
      type: 'string',
      default: '0'
    }
  },
  keywords: [__('List'), __('Styled List'), __('Heroic Blocks')],
  edit: compose([withState({
    availableIcons: [],
    iconSearchTerm: '',
    recentSelection: '',
    edits: 0
  }), withSelect((select, ownProps) => ({
    block: (select('core/block-editor') || select('core/editor')).getBlock(ownProps.clientId)
  }))])(function (props) {
    const {
      block,
      isSelected,
      attributes,
      setAttributes,
      setState,
      availableIcons,
      iconSearchTerm,
      edits
    } = props;
    const {
      list,
      iconColor,
      iconRound,
      blockID
    } = attributes;
    const selected = {
      start: 10,
      end: 20
    };

    if (blockID !== block.clientId) {
      setAttributes({
        blockID: block.clientId
      });
    }

    useEffect(() => {
      /* placeholder functionality for setting initial item to highlighted */
    });
    return [isSelected && React.createElement(InspectorControls, null, React.createElement(PanelBody, {
      title: __('Icon Options')
    }, React.createElement("p", null, __('Icon color')), React.createElement(ColorPalette, {
      value: iconColor,
      onChange: colorValue => {
        setAttributes({
          iconColor: colorValue
        });
      },
      allowReset: true
    }), React.createElement("p", null, __('Button Style')), React.createElement(SelectControl, {
      value: iconRound,
      range: selected,
      options: [{
        label: __('Boxed'),
        value: '0'
      }, {
        label: __('Rounded'),
        value: '99%'
      }],
      onChange: pos => setAttributes({
        iconRound: pos
      })
    }))), React.createElement("div", {
      className: "heroic-styled-list",
      id: `heroic-styled-list-${blockID}`
    }, React.createElement(RichText, {
      className: "fa-ul",
      multiline: "li" //tagName="ol"
      ,
      value: list,
      onChange: newList => {
        //newList = newList.replace("<ul>", '<ul class="fa-ul">');
        setAttributes({
          list: newList
        });
      },
      placeholder: __('List Item One. Press Enter to add items.'),
      keepPlaceholderOnFocus: true
    }), React.createElement("style", {
      dangerouslySetInnerHTML: {
        __html: `#heroic-styled-list-${blockID} li:before{
                       background:${iconColor};
                       border-radius: ${iconRound};
                       }`
      }
    }))];
  }),
  save: function ({
    attributes
  }) {
    const {
      list,
      iconColor,
      iconRound,
      blockID
    } = attributes;
    console.log('saving list');
    console.log(list);
    return React.createElement("div", {
      className: "heroic-styled-list",
      id: `heroic-styled-list-${blockID}`
    }, React.createElement(RichText.Content, {
      className: "fa-ul",
      multiline: "li",
      tagName: "ol",
      value: list
    }), React.createElement("style", {
      dangerouslySetInnerHTML: {
        __html: `#heroic-styled-list-${blockID} li:before{
		                   background:${iconColor};
		                   border-radius: ${iconRound};
		                   }`
      }
    }));
  }
});
//# sourceMappingURL=list-block.js.map
