<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AppVulnerabilityTaskMitigationType File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* AppVulnerabilityTaskMitigationType class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AppVulnerabilityTaskMitigationType extends Enum
{
    /**
    * The Enum AppVulnerabilityTaskMitigationType
    */
    const UNKNOWN = "unknown";
    const UPDATE = "update";
    const UNINSTALL = "uninstall";
    const SECURITY_CONFIGURATION = "securityConfiguration";
}