//# sourceMappingURL=ht-shortcodes-tabs-block-source.jsx.map
/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */

const { __ } = wp.i18n; // Import __() from wp.i18n
const { registerBlockType } = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText,
  InnerBlocks,
} = wp.editor;

const {
	Panel,
	PanelBody,
	PanelRow,
	RangeControl,
	SelectControl,
	TextControl,
} = wp.components;

const { Fragment, Component } = wp.element;

const blockIcon = (
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" strokeWidth="2">
                <g fill="none" stroke="#555d66" strokeLinecap="square" strokeMiterlimit="10">
                    <path d="M2 2h20v20H2z"/>
                    <path d="M12 7v10M17 12H7"/>
                </g>
            </svg>
        );

/**
 * Register Block
 */
registerBlockType( 'ht-blocks/toggle', {
	title: __( 'Heroic Blocks - Toggle' ),
	description: __( 'This is the toggle block used for expandable sections' ),
	icon: {
            src: blockIcon,
            foreground: 'auto',
        },
	category: 'heroic-blocks', 
	keywords: [
		__( 'Heroic Blocks' ),
		__( 'Tabs' ),
        __( 'tabs' ),
	],

    attributes: {
        title: {
            type: 'string',
            source: 'html',
            selector: '.wp-block-hb-toggle__title span'
        },
        content: {
            type: 'string',
            source: 'html',
            selector: '.wp-block-hb-toggle__contentwrap'
        },
        baseClassName: {
            type: 'string',
            default: 'wp-block-hb-toggle'
        },
        
    },

    edit: function( {className, attributes, setAttributes} ) {
        const { title, content,  baseClassName } = attributes;

        function onChangeTitle( newTitle ) {
            setAttributes( { title: newTitle } );            
        }

        function onChangeContent( newContent ) {
            setAttributes( { content: newContent } );            
        }

        return (
                <Fragment>
                    <InspectorControls
                        key='inspector'
                    >
                        <PanelBody
                            title={ __( 'Toggle') }
                            className='ht-blocks-tabs-panel-body'
                            initialOpen={ true }
                        >
                            <div className='ht-blocks-toggle-block-control'>{ __( 'Control this Toggle Block' ) }</div>
                        </PanelBody>
                    </InspectorControls>
                    <div className={ className + ' ' + baseClassName + ' ' + baseClassName + '--active' } >
                      
                        <div className={ baseClassName + '__title' }  >
                            <RichText   tagName='span' 
                                        value={ title } 
                                        onChange={ (newTitle) => onChangeTitle(newTitle) } 
                                        placeholder={ __( 'Enter your title here' ) }
                                        keepPlaceholderOnFocus={ true }
                            />    
                        </div>
                        <div className={ baseClassName + '__content' }  >                   
                            <RichText   tagName='div' 
                                        className={ baseClassName + '__contentwrap' } 
                                        value={ content } 
                                        onChange={ (newContent) => onChangeContent(newContent) } 
                                        placeholder={ __( 'Enter your content here' ) }
                                        keepPlaceholderOnFocus={ true }
                            />
                        </div>
                      
                    </div>
                </Fragment>
            );
    },



    save: function( { attributes  } ) {

        const { title, content, baseClassName } = attributes;

        return (
                    <div className={ baseClassName } >  
                        <div className={ baseClassName + '__title' }  >                   
                            <RichText.Content tagName='span'  value={ title } />  
                        </div>
                        <div className={ baseClassName + '__content' }  >                      
                            <RichText.Content tagName='div'  className={ baseClassName + '__contentwrap' } value={ content } />    
                        </div>                  
                    </div>

        );
    },

} );

console.log('Toggle Block Loaded');
