const { __ } = wp.i18n;

const { useEffect } = wp.element;

const { registerBlockType } = wp.blocks;
const {
	RichText,
	InspectorControls,
	ColorPalette,
	AlignmentToolbar,
	BlockControls,
	} = wp.blockEditor || wp.editor;
const { IconButton, Dropdown, PanelBody, RangeControl, SelectControl } = wp.components;
const { withState, compose } = wp.compose;
const { withSelect } = wp.data;


registerBlockType( 'ht-blocks/list', {
	title: __( 'Heroic Blocks - List' ),
	//@todo - replace with custom icon
	icon: 'editor-ol',
	category: 'heroic-blocks', 
	attributes: {
		blockID: {
			type: 'string',
			default: ''
		},
		list: {
			type: 'text',
			//todo default should have placeholders not items
			//default: '<li>Item 1</li><li>Item 2</li><li>Item 3</li>'		
		},
		iconColor: {
			type: 'string',
			default: '#000000'
		},
		iconRound: {
			type: 'string',
			default: '0'
		}
	},
	keywords: [	__( 'List' ), 
				__( 'Styled List' ), 
				__( 'Heroic Blocks' )
	],
	edit: compose([
		withState({
			availableIcons: [],
			iconSearchTerm: '',
			recentSelection: '',
			edits: 0
		}),
		withSelect((select, ownProps) => ({
			block: (select('core/block-editor') || select('core/editor')).getBlock(
				ownProps.clientId
			)
		}))
	])(function(props) {

		const {
			block,
			isSelected,
			attributes,
			setAttributes,
			setState,
			availableIcons,
			iconSearchTerm,
			edits
			} = props;

		const {
			list,
			iconColor,
			iconRound,
			blockID
			} = attributes;

		const selected = {start: 10, end: 20};

		if (blockID !== block.clientId) {
			setAttributes({ blockID: block.clientId });
		}

		useEffect(() => { /* placeholder functionality for setting initial item to highlighted */ });

		return [
			isSelected && (
				<InspectorControls>
					<PanelBody title={__('Icon Options')}>
						<p>{__('Icon color')}</p>
						<ColorPalette
							value={iconColor}
							onChange={colorValue => { setAttributes({ iconColor: colorValue }) }}
							allowReset
						/>
						<p>{__('Button Style')}</p>
						<SelectControl
							value={iconRound}
							range={ selected }
							options={[
                            {
								label: __('Boxed'),
								value: '0'
							},
							{
								label: __('Rounded'),
								value: '99%'
							}
						]}
							onChange={pos => setAttributes({ iconRound: pos })}
						/>
					</PanelBody>
				</InspectorControls>
			),


			<div
				className="heroic-styled-list"
				id={`heroic-styled-list-${blockID}`}
			>
				<RichText
					className="fa-ul"
					multiline="li"
					//tagName="ol"
					value={list}
					onChange={newList => {
						//newList = newList.replace("<ul>", '<ul class="fa-ul">');
						setAttributes({ list: newList });
					}}
					placeholder={ __( 'List Item One. Press Enter to add items.' ) }
					keepPlaceholderOnFocus={ true }
				/>

				<style
					dangerouslySetInnerHTML={{
						__html: `#heroic-styled-list-${blockID} li:before{
                       background:${iconColor};
                       border-radius: ${iconRound};
                       }`
					}}
				/>
			</div>
		];
	}),

	save: function( {  attributes  } ) {
        const {
			list,
			iconColor,
			iconRound,
			blockID
		} = attributes;

		console.log('saving list');
		console.log(list);

        return (
		        <div
					className="heroic-styled-list"
					id={`heroic-styled-list-${blockID}`}
				>
					<RichText.Content
						className="fa-ul"
						multiline="li"
						tagName="ol"
						value={list}
					/>

					<style
						dangerouslySetInnerHTML={{
							__html: `#heroic-styled-list-${blockID} li:before{
		                   background:${iconColor};
		                   border-radius: ${iconRound};
		                   }`
						}}
					/>
			    </div>
        );

    },
});
