import './image-block-frontend.js';
const {
  __
} = wp.i18n;
const {
  registerBlockType
} = wp.blocks;
const {
  MediaUpload,
  MediaPlaceholder,
  BlockControls,
  URLInput,
  InspectorControls,
  mediaUpload,
  BlockAlignmentToolbar,
  BlockIcon,
  InspectorAdvancedControls,
  MediaReplaceFlow,
  RichText
} = wp.blockEditor || wp.editor;
const {
  Spinner,
  Notice
} = wp.components;
const {
  getBlobByURL,
  isBlobURL,
  revokeBlobURL
} = wp.blob;
const attributes = {
  imgUrl: {
    type: 'string',
    //set with wp_localize script
    default: customVars.mediaPlaceholder
  },
  imgUploading: {
    type: 'boolean',
    default: false
  }
};
export const ALLOWED_MEDIA_TYPES = ['image'];

const zoomImage = function (blockID) {
  jQuery('[data-block="' + blockID + '"]').find('.hb-magnify').first().htImageZoom();
};

registerBlockType('ht-blocks/image', {
  title: __('Heroic Blocks - Zoomable Image'),
  //@todo - replace with custom icon
  icon: 'format-image',
  category: 'heroic-blocks',
  keywords: [__('Image'), __('Zoom'), __('Heroic Image')],
  attributes,

  edit(props) {
    const {
      className,
      setAttributes
    } = props;
    const {
      attributes
    } = props;
    const labels = {
      title: __('Image Zoom'),
      instructions: __('Upload an image file or pick from your media library. A magnification glass will appear when a visitor hovers on the image.')
    };
    const icon = 'search';
    const {
      id,
      imgUrl,
      imgUploading
    } = attributes;
    const mediaPreview = React.createElement("img", {
      alt: __('Edit image'),
      title: __('Edit image'),
      className: 'edit-image-preview',
      src: imgUrl
    });

    const ImageUploading = props => {
      //could also use wp.data.dispatch('core/notices').createNotice(
      return React.createElement(Notice, {
        status: "info",
        isDismissible: true,
        onRemove: null
      }, React.createElement(Spinner, null), "  ", __('Please wait, image uploading'));
    };

    function selectImage(value) {
      //if value.id exists, item has been saved to media gallery
      if (typeof value === 'object' && value !== null && 'id' in value) {
        //the media has been uploaded, unlock the editor save
        wp.data.dispatch('core/editor').unlockPostSaving();
        setAttributes({
          imgUploading: false,
          imgUrl: value.url
        });
      } else {
        //media not yet ready
        wp.data.dispatch('core/editor').lockPostSaving();
        setAttributes({
          imgUploading: true
        });
      }
    }

    return [React.createElement(InspectorControls, null, React.createElement("div", {
      style: {
        padding: '1em 0'
      }
    }, "Options")), React.createElement("div", {
      className: className
    }, imgUploading ? React.createElement(ImageUploading, null) : imgUrl != customVars.mediaPlaceholder ? React.createElement("div", {
      id: props.clientId,
      class: "hb-magnify"
    }, zoomImage(props.clientId), React.createElement("div", {
      class: "hb-magnify__large"
    }), React.createElement("img", {
      class: "hb-magnify__small",
      src: imgUrl,
      width: "720"
    })) : React.createElement("div", {
      className: "media"
    }, React.createElement(MediaPlaceholder, {
      onSelect: selectImage,
      allowedTypes: ['image'],
      multiple: false,
      labels: {
        title: __('Image Zoom')
      }
    })))];
  },

  save: function ({
    attributes
  }) {
    const {
      id,
      imgUrl
    } = attributes;
    return React.createElement("div", {
      class: "hb-magnify"
    }, React.createElement("div", {
      class: "hb-magnify__large"
    }), React.createElement("img", {
      class: "hb-magnify__small",
      src: imgUrl,
      width: "720"
    }));
  }
});
//# sourceMappingURL=image-block.js.map
