/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */
//import './ht-shortcodes-messages-block-style.css';
const {
  __
} = wp.i18n; // Import __() from wp.i18n

const {
  registerBlockType
} = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText
} = wp.editor;
const {
  Panel,
  PanelBody,
  PanelRow,
  RangeControl,
  SelectControl,
  TextControl,
  CheckboxControl,
  ColorPicker
} = wp.components;
const {
  Fragment
} = wp.element;
const blockIcon = React.createElement("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  strokeWidth: "2"
}, React.createElement("g", null, React.createElement("path", {
  fill: "none",
  stroke: "#555d66",
  strokeLinecap: "square",
  strokeMiterlimit: "10",
  d: "M2 1h20v22H2z"
}), React.createElement("path", {
  fill: "none",
  stroke: "#555d66",
  strokeLinecap: "square",
  strokeMiterlimit: "10",
  d: "M12 7v7"
}), React.createElement("circle", {
  stroke: "none",
  fill: "#555d66",
  cx: "12",
  cy: "18",
  r: "1"
})));
/**
 * Register Block
 */

registerBlockType('ht-blocks/messages', {
  title: __('Heroic Blocks - Messages'),
  description: __('Add a message callout'),
  icon: {
    src: blockIcon,
    foreground: 'auto'
  },
  category: 'heroic-blocks',
  keywords: [__('Heroic Blocks'), __('Message'), __('messages')],
  attributes: {
    content: {
      source: 'html',
      selector: 'p'
    },
    showIcon: {
      type: 'boolean',
      default: true
    },
    showIconClassName: {
      type: 'string',
      default: 'withicon'
    },
    baseClassName: {
      type: 'string',
      default: 'wp-block-hb-message'
    },
    backgroundColor: {
      type: 'string',
      default: '#f00'
    },
    textColor: {
      type: 'string',
      default: '#000'
    }
  },
  styles: [{
    name: 'success',
    label: __('Success'),
    isDefault: true
  }, {
    name: 'alert',
    label: __('Alert')
  }, {
    name: 'danger',
    label: __('Danger')
  }, {
    name: 'info',
    label: __('Information')
  }],
  supports: {
    align: true
  },
  edit: function ({
    className,
    attributes,
    setAttributes
  }) {
    const {
      content,
      showIcon,
      showIconClassName,
      baseClassName,
      backgroundColor,
      textColor
    } = attributes;

    const onChangeContent = newContent => {
      setAttributes({
        content: newContent
      });
    };

    const onChangeShowIcon = newShowIcon => {
      setAttributes({
        showIcon: newShowIcon
      });
      console.log('newShowIcon->' + newShowIcon);
      setAttributes({
        showIconClassName: newShowIcon ? 'withicon' : 'noicon'
      });
      console.log('showIconClassName->' + showIconClassName);
    };

    const onChangeCompleteBackgroundColor = color => {
      console.log('newBackroundColor->' + color.hex);
      setAttributes({
        backgroundColor: color.hex
      });
    };

    return React.createElement(Fragment, null, React.createElement(InspectorControls, {
      key: "inspector"
    }, React.createElement(PanelBody, {
      title: __('Options'),
      className: "heroic-blocks-messages-panel-body",
      initialOpen: false
    }, React.createElement("div", {
      className: "ht-blocks-messages-block-control"
    }, __('Control this Messages Block')), React.createElement(CheckboxControl, {
      label: __('Show Icon'),
      checked: showIcon,
      onChange: onChangeShowIcon
    }))), React.createElement(RichText, {
      className: className + ' ' + baseClassName + ' ' + baseClassName + '--' + showIconClassName,
      tagName: "p",
      onChange: onChangeContent,
      placeholder: __('This will be the message'),
      keepPlaceholderOnFocus: true //style={ 'color:' + textColor + ';background-color:'+ backgroundColor + ';' } 
      ,
      value: content
    }));
  },
  save: function ({
    attributes
  }) {
    const {
      content,
      showIcon,
      showIconClassName,
      baseClassName,
      backgroundColor,
      textColor
    } = attributes;
    console.log('base'); //backgroundColor
    //textColor
    //console.log(baseClassName);

    return React.createElement(RichText.Content, {
      className: baseClassName + ' ' + baseClassName + '--' + showIconClassName,
      tagName: "p" //style={ 'color:' + textColor + ';background-color:'+ backgroundColor + ';' } 
      ,
      value: content
    });
  }
});
//# sourceMappingURL=messages-block.js.map
