import './image-block-frontend.js';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;

const {
    MediaUpload,
    MediaPlaceholder,
    BlockControls,
    URLInput,
    InspectorControls,
    mediaUpload,
    BlockAlignmentToolbar,
    BlockIcon,
    InspectorAdvancedControls,
    MediaReplaceFlow,
    RichText
    } = wp.blockEditor || wp.editor;


const { Spinner, Notice } = wp.components;

const { getBlobByURL, isBlobURL, revokeBlobURL } = wp.blob;

const attributes = {
    imgUrl: {
        type: 'string',
        //set with wp_localize script
        default: customVars.mediaPlaceholder
    },
    imgUploading: {
        type: 'boolean',
        default: false,
    }
};

export const ALLOWED_MEDIA_TYPES = [ 'image' ];

const zoomImage = function(blockID){
    jQuery('[data-block="'+blockID+'"]').find('.hb-magnify').first().htImageZoom();
}

registerBlockType( 'ht-blocks/image', {
    title: __( 'Heroic Blocks - Zoomable Image' ),
    //@todo - replace with custom icon
    icon: 'format-image',
    category: 'heroic-blocks', 
    keywords: [ __('Image'), 
                __('Zoom'), 
                __('Heroic Image')
            ],
    attributes,


    edit(props) {
        const { className, setAttributes } = props;
        const { attributes } = props;
        const labels = {
            title: __( 'Image Zoom' ),
            instructions: __(
                'Upload an image file or pick from your media library. A magnification glass will appear when a visitor hovers on the image.'
            ),
        };
        const icon = 'search';
        const {
                id,
                imgUrl,
                imgUploading,
            } = attributes;
        const mediaPreview = (
            <img
                alt={ __( 'Edit image' ) }
                title={ __( 'Edit image' ) }
                className={ 'edit-image-preview' }
                src={ imgUrl }
            />
        );

        const ImageUploading = (props) => {
                //could also use wp.data.dispatch('core/notices').createNotice(
                return  <Notice
                            status="info"
                            isDismissible={true}
                            onRemove={ null }
                        >                    
                            <Spinner />  { __('Please wait, image uploading') }
                        </Notice>      
               
        };

        function selectImage( value ) {
            //if value.id exists, item has been saved to media gallery
            if(typeof value === 'object' && value !== null && 'id' in value){
                //the media has been uploaded, unlock the editor save
                wp.data.dispatch('core/editor').unlockPostSaving();
                setAttributes({
                    imgUploading: false,
                    imgUrl: value.url,
                });
            } else {
                //media not yet ready
                wp.data.dispatch('core/editor').lockPostSaving();
                setAttributes({
                    imgUploading: true,
                });
            }
        }

        return [
            <InspectorControls>
                {/* todo - inspector controls - eg magnification factor etc */}
                <div
                    style={{
                        padding: '1em 0',
                    }}
                >
                    Options
                </div>
            </InspectorControls>,
            <div className={className}>
                { ( imgUploading  ) ?
                    <ImageUploading />
                : 
                  (imgUrl != customVars.mediaPlaceholder ) ?
                    <div id={ props.clientId } class="hb-magnify">
                        { zoomImage(props.clientId) }
                        <div class="hb-magnify__large"></div>
                        <img class="hb-magnify__small" src={ imgUrl } width="720"/>   
                    </div>
                :
                    <div className="media">
                        <MediaPlaceholder
                            onSelect = { selectImage }
                            allowedTypes = { [ 'image' ] }
                            multiple = { false }
                            labels = { { title: __('Image Zoom') } }
                        >
                        </MediaPlaceholder>
                    </div>
                }
            </div>,
        ];
    },

    save: function( {  attributes  } ) {
        const {
            id,
            imgUrl,
        } = attributes;

        return (
                <div class="hb-magnify">
                    <div class="hb-magnify__large"></div>
                    <img class="hb-magnify__small" src={ imgUrl } width="720"/>   
                </div>
        );

    },
});
