function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Registering a basic block with Gutenberg.
 * Simple block, renders and saves the same content without any interactivity.
 */
const {
  __
} = wp.i18n; // Import __() from wp.i18n

const {
  registerBlockType
} = wp.blocks; // Import registerBlockType() from wp.blocks

const {
  InspectorControls,
  BlockDescription,
  RichText,
  InnerBlocks
} = wp.editor;
const {
  Panel,
  PanelBody,
  PanelRow,
  RangeControl,
  SelectControl,
  TextControl,
  Dashicon,
  Tooltip
} = wp.components;
const {
  Fragment,
  Component
} = wp.element;
const blockIcon = React.createElement("svg", {
  xmlns: "http://www.w3.org/2000/svg",
  width: "20",
  height: "20",
  strokeWidth: "2"
}, React.createElement("g", {
  fill: "none",
  stroke: "#555d66",
  strokeLinecap: "square",
  strokeMiterlimit: "10"
}, React.createElement("path", {
  d: "M2 10h20v4H2z"
}), React.createElement("path", {
  d: "M2 2h20v4H2zM2 18h20v4H2z"
})));
/**
 * Register Block
 */

registerBlockType('ht-blocks/accordion', {
  title: __('Heroic Blocks - Accordion'),
  description: __('This is the accordion block used for sections'),
  icon: {
    src: blockIcon,
    foreground: 'auto'
  },
  category: 'heroic-blocks',
  keywords: [__('Heroic Blocks'), __('Accordion'), __('accordion')],
  attributes: {
    baseClassName: {
      type: 'string',
      default: 'wp-block-hb-accordion'
    },
    sections: {
      type: 'array',
      source: 'query',
      selector: '.wp-block-hb-accordion__section',
      query: {
        head: {
          type: 'string',
          source: 'html',
          selector: '.wp-block-hb-accordion__title span'
        },
        content: {
          type: 'string',
          source: 'html',
          selector: '.wp-block-hb-accordion__contentwrap'
        }
      },
      default: [{
        head: '',
        content: ''
      }, {
        head: '',
        content: ''
      }, {
        head: '',
        content: ''
      }]
    }
  },
  edit: function ({
    className,
    attributes,
    setAttributes
  }) {
    const {
      content,
      sections,
      baseClassName
    } = attributes;

    const updateAccordionSectionHead = (index, newSectionHead) => {
      //create copy with modified values
      var newSections = [...sections];
      newSections[index].head = newSectionHead;
      setAttributes({
        sections: newSections
      });
    };

    const updateAccordionSectionContent = (index, newSectionContent) => {
      //create copy with modified values
      var newSections = [...sections];
      newSections[index].content = newSectionContent;
      setAttributes({
        sections: newSections
      });
    };

    const addSection = () => {
      console.log('add section clicked');
      var newSection = {
        head: {},
        content: {}
      };
      setAttributes({
        sections: [...sections, newSection]
      });
    };

    const removeSection = index => {
      console.log('remove section clicked index->' + index);

      const confirmMsg = __('Are you sure you wish to remove this section?');

      if (confirm(confirmMsg)) {
        setAttributes({
          sections: sections.filter((el, indx) => indx !== index)
        });
      }
    };

    var defaultState = {
      'data-ht-blocks-accordion-block-state': 'closed'
    };
    return React.createElement(Fragment, null, React.createElement(InspectorControls, {
      key: "inspector"
    }, React.createElement(PanelBody, {
      title: __('Accordion'),
      className: "heroic-blocks-accordion-panel-body",
      initialOpen: true
    }, React.createElement("div", {
      className: "ht-blocks-accordion-block-control"
    }, __('Control this accordion block')))), React.createElement("div", {
      className: className + ' ' + baseClassName
    }, sections.map((section, index) => React.createElement(Fragment, {
      key: index
    }, React.createElement("div", _extends({
      className: baseClassName + '__section' + ' ' + baseClassName + '__section--active'
    }, defaultState), React.createElement("div", {
      className: baseClassName + '__title'
    }, React.createElement(RichText, {
      tagName: "span",
      value: section.head,
      onChange: newSectionHead => updateAccordionSectionHead(index, newSectionHead),
      placeholder: __('Accordion Heading') + ' ' + (index + 1).toString(),
      keepPlaceholderOnFocus: true
    }), React.createElement(Tooltip, {
      text: __('Remove Section')
    }, React.createElement("span", {
      onClick: () => removeSection(index),
      className: baseClassName + '__remove_btn'
    }, React.createElement(Dashicon, {
      icon: "dismiss"
    })))), React.createElement("div", {
      className: baseClassName + '__content'
    }, React.createElement(RichText, {
      tagName: "div",
      className: baseClassName + '__contentwrap',
      value: section.content,
      onChange: newSectionContent => updateAccordionSectionContent(index, newSectionContent),
      placeholder: __('Enter your content here for accordion section ') + ' ' + (index + 1).toString(),
      keepPlaceholderOnFocus: true
    }))))), React.createElement(Tooltip, {
      text: __('Add Section')
    }, React.createElement("span", {
      onClick: addSection,
      className: baseClassName + '__add_btn'
    }, React.createElement(Dashicon, {
      icon: "plus-alt"
    })))));
  },
  save: function ({
    attributes
  }) {
    const {
      sections,
      baseClassName
    } = attributes;
    var defaultState = {
      'data-ht-blocks-accordion-block-state': 'closed'
    };
    return React.createElement("div", {
      className: baseClassName
    }, sections.map((section, index) => React.createElement(Fragment, null, React.createElement("div", _extends({
      className: baseClassName + '__section'
    }, defaultState), React.createElement("div", {
      className: baseClassName + '__title'
    }, React.createElement(RichText.Content, {
      tagName: "span",
      value: section.head
    })), React.createElement("div", {
      className: baseClassName + '__content'
    }, React.createElement(RichText.Content, {
      tagName: "div",
      className: baseClassName + '__contentwrap',
      value: section.content
    }))))));
  }
});
console.log('Accordion Block Loaded');
//# sourceMappingURL=accordion-block.js.map
