<?php
/**
 * Template Name: Blog (Home)
 *
 * @package ThinkUpThemes
 */

get_header(); ?>

			<?php
				$thinkup_blog_pageid = $post->ID; // Store page id to collect meta data in project loop
			?>

			<?php
			$categories = NULL;
			$posttags   = get_the_tags();
			if( is_array( get_the_tags() ) ) { $tag_count = sizeof( get_the_tags() ); }

			// Find category ID's for tag name and comma separate
			if ($posttags) {
				foreach($posttags as $tag) {
					if ($count !== ( $tag_count - 1 ) ) {
						$categories .= get_cat_ID( $tag->name ) . ',';
					} else {
						$categories .= get_cat_ID( $tag->name );
					}
					$count++;
				}
			}
			?>

			<?php
			// Ensure pagination works correctly on both front page and inner pages
			if ( is_front_page() ) {
				$paged = ( get_query_var('page') ) ? get_query_var('page') : 1;
			} else {
				$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
			}

			// Run query to collect blog posts
			$loop_args = array(
				'post_type'      => 'post',
				'post_status'    => 'publish',
				'cat'            => $categories,
				'posts_per_page' => -1,
				'paged'          => $paged,
				'page'           => $paged,
				'orderby'        => 'modified',
			);
			$loop = new WP_Query( $loop_args );
			?>

			<?php global $more; $more = 0; ?>

			<?php $categoryIds = get_all_category_ids(); // Get all post categories ?>

			<?php if ( $loop->have_posts() ) : ?>

				<?php while ( $loop->have_posts() ) : $loop->the_post(); // Output featured post ?>

					<?php
						$tags = get_the_tags();

						// Skip to next iteration if no tags are present
						if( empty( $tags ) ) {
							continue;
						}
					?>

					<?php
					// Loop through each tag
					foreach( $tags as $tagsPost ): ?>

						<?php if( $tagsPost->slug == 'featured' ): // Output featured post if set ?>

							<section class="container blog-featured">

								<div class="container-core">

									<div class="blog-grid-item element<?php // thinkup_input_stylelayout(); ?>">

									<article id="post-<?php the_ID(); ?>" <?php post_class(['blog-article', 'block-flex', 'flex-gap-40', 'w800-block-flex-column']); ?>>

										<header class="entry-header<?php // thinkup_input_stylelayout_class1(); ?> flex-col-2">
											<?php thinkup_input_blogimage(); ?>
										</header>

										<div class="entry-content<?php // thinkup_input_stylelayout_class2(); ?> flex-col-2">
											<?php thinkup_input_blogmeta(); ?>
											<?php thinkup_input_blogtitle('h1'); ?>
											<?php thinkup_input_blogtext(22); ?>
											<?php // thinkup_input_readmore(); ?>
										</div>

									<div class="clearboth"></div>
									</article><!-- #post-<?php get_the_ID(); ?> -->

									</div>

								</div>

							</section>

							<?php break; // Exit on first match ?>

						<?php endif; ?>

					<?php endforeach; ?>

				<?php endwhile; ?>

				<?php foreach($categoryIds as $categoryId): // Loop through each category ?>

					<?php
						// Assign default variable values used within loop
						$count = (int) null;

						// Skip to next iteration if no posts in category, or uncategorized
						if( empty( get_posts( array( 'category' => $categoryId ) ) ) || $categoryId == 1 ) {
							continue;
						}
					?>

					<section class="container blog-posts" data-count="<?php echo $count; ?>">

						<div class="container-core">

							<div class="block-header block-flex">

								<div class="block-category">
									<h3 class="block-title margin-0"><?php echo get_cat_name( $categoryId ); ?></h3>
								</div>

								<div class="block-link">
									<a href="<?php echo untrailingslashit( get_home_url() ) ?>/<?php echo strtolower( get_cat_name( $categoryId ) ); ?>">View All<i class="fal fa-long-arrow-right"></i></a>
								</div>

							</div>

							<div class="block-content">

								<div class="blog-grid block-grid grid-col-3 grid-gap-50 w800-grid-col-1">

									<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>

										<?php
											// Assign default variable values used within loop
											$show     = false;
											$featured = false;

											// Get tags and category names
											$tags     = wp_get_post_terms(get_the_id(), 'post_tag');
											$category = wp_get_post_terms(get_the_id(), 'category');

											// Loop through each tag
											foreach( $tags as $tagsPost ){

												// Skip if post is set as featured post
												if( $tagsPost->slug == 'featured' ) {
													$featured = true;
													break;
												}
											}

											// Check if post should show for current category
											foreach( $category as $categoryPost ) {

												// Convert to array
	//											$categoryPost = array($categoryPost);

												// Get category term ID
												$term_id = (int) (isset($categoryPost->term_id) ? $categoryPost->term_id : null);

												// Exit loop on first match
												if( $term_id == $categoryId ) {
													$show = true;
													break;
												}
											}

											// Skip if current post shouldn't be shown
											if( ! empty( $featured ) || empty( $show ) || $count >= 3 ) {
												continue;
											}

											// Increase count
											$count++;
										?>

										<div class="blog-grid-item element<?php // thinkup_input_stylelayout(); ?>">

										<article id="post-<?php the_ID(); ?>" <?php post_class('blog-article'); ?>>

											<header class="entry-header<?php thinkup_input_stylelayout_class1(); ?>">
												<?php thinkup_input_blogimage(); ?>
											</header>

											<div class="entry-content<?php thinkup_input_stylelayout_class2(); ?>">
												<?php thinkup_input_blogmeta(); ?>
												<?php thinkup_input_blogtitle(); ?>
												<?php thinkup_input_blogtext(21); ?>
												<?php // thinkup_input_readmore(); ?>
											</div>

										<div class="clearboth"></div>
										</article><!-- #post-<?php get_the_ID(); ?> -->

										</div>

									<?php endwhile; ?>

								</div>

							</div>

						</div>

					</section><div class="clearboth"></div>

					<?php // thinkup_input_pagination( $loop->max_num_pages ); ?>

				<?php endforeach; ?>

			<?php else: ?>

				<?php get_template_part( 'no-results', 'archive' ); ?>

			<?php endif; wp_reset_postdata(); ?>

<?php get_footer() ?>