<?php

// Items for column 1
$items_col1 = array(
	array(
		'title' => 'Can I build websites for my clients?',
		'text'  => 'Absolutely. You can use all of our themes for both personal and commercial use. So if you run a web agency, you can use our themes to build as many websites as you want for as many client as you like.',
	),
	array(
		'title' => 'Do you have a page builder?',
		'text'  => 'Absolutely, all of our themes come with a drag & drop page builder which can be used to fully customize your site without ever touching a single line of code.',
	),
	array(
		'title' => 'How can I pay?',
		'text'  => 'Currently we only accept PayPal for registration. If you don’t have a PayPal account you can still register using your credit or debit card using PayPal.',
	),
	array(
		'title' => 'Why are your themes so affordable?',
		'text'  => 'We don’t believe that WordPress should be exploited for big profits, and instead we focus on delivering quality products at the most affordable price.',
	),
	array(
		'title' => 'What makes your themes ‘Premium’?',
		'text'  => 'Our themes have beautiful designs, and come packed with features! Plus they\'re coded with fully valid CSS3 and HTML5, so you can be sure your site will look great and work smoothly on every device.',
	),
);

// Items for column 2
$items_col2 = array(
	array(
		'title' => 'Do you provide support?',
		'text'  => 'Yes, support is provided directly by the theme developers through a ticketed support system. All of our themes come with 1 year access to the support center. For access to the support center after this period you can re-purchase the theme or renew renew your subscription.',
	),
	array(
		'title' => 'How do your renewals work?',
		'text'  => 'All of our subscriptions are manual renewal, so you\'ll never be billed automatically. This gives you total control over your license, and you can renew when it\'s good for you.',
	),
	array(
		'title' => 'How do I download the themes?',
		'text'  => 'After subscribing you will be directed to the members area from where all the available themes can be downloaded. These are available in .zip format.',
	),
	array(
		'title' => 'Will your themes work with plugins?',
		'text'  => 'Each theme has been developed using WordPress best practices and where possible we have used the WordPress codex functions. We guarantee that our themes will work with the included / recommended plugins.',
	),
	array(
		'title' => 'What version of WordPress do I need?',
		'text'  => 'All of our themes have been tested to the latest WordPress version and are compatible with all WordPress versions since 5.0.',
	),
);

?>

<section class="container page-section page-section5 pricing-section pricing-section5">
	<div class="container-core">

		<div class="container-row pricing-section5-row1">

			<h3 class="block-title">Frequently asked questions</h3>

		</div>

		<div class="container-row pricing-section5-row2 block-flex flex-gap-30 block-flex-start w800-block-flex-column">

			<div class="container-col pricing-section5-col1 block-grid grid-gap-30 flex-col-2">

				<?php foreach( $items_col1 as $item ): ?>

					<?php
						// Extract values from item
						$item_title = (string) (isset($item['title']) ? $item['title'] : null);
						$item_text  = (string) (isset($item['text'])  ? $item['text']  : null);
					?>

					<div class="block-card block-style3">

						<div class="block-header">
							<h4 class="block-title"><?php echo $item_title; ?></h4>
						</div>

						<div class="block-body">

							<div class="block-text">
								<p><?php echo $item_text; ?></p>
							</div>

						</div>

					</div>

				<?php endforeach; ?>

			</div>
			<!-- .pricing-section5-col1 -->

			<div class="container-col pricing-section5-col2 block-grid grid-gap-30 flex-col-2">

				<?php foreach( $items_col2 as $item ): ?>

					<?php
						// Extract values from item
						$item_title = (string) (isset($item['title']) ? $item['title'] : null);
						$item_text  = (string) (isset($item['text'])  ? $item['text']  : null);
					?>

					<div class="block-card block-style3">

						<div class="block-header">
							<h4 class="block-title"><?php echo $item_title; ?></h4>
						</div>

						<div class="block-body">

							<div class="block-text">
								<p><?php echo $item_text; ?></p>
							</div>

						</div>

					</div>

				<?php endforeach; ?>

			</div>
			<!-- .pricing-section5-col2 -->

		</div>

	</div>
</section>