<section class="container page-section page-section2 home-section home-section5">
	<div class="container-core">

		<div class="container-row home-section5-row1">

			<h3 class="block-title">Choose from 27 amazing themes!</h3>

		</div>

		<div class="container-row home-section5-row2">

			<?php
			// Set arguments to get WooCommerce products
			$args = array(
				'post_type'   => 'product',
				'numberposts' => 24
			);

			// Get WooCommerce products (as array)
			$products = (array) get_posts($args);
			?>

			<div class="block-products block-style1 block-grid grid-col-3 grid-row-gap-30 grid-column-gap-30 w800-grid-col-2 w480-grid-col-1">

				<?php
					// Loop through each product and output
					foreach($products as $product ):

					// Reset variables used within loop
					$skip = false;

					// Convert product object to array
					$product = (array) $product;

					// Extract product info
					$product_id           = $product['ID'];
					$product_post_title   = $product['post_title'];
					$product_post_excerpt = $product['post_excerpt'];

					// Get product details
					$get_product = wc_get_product( $product_id );

					// Get product prices
					$product_regular_price = $get_product->get_regular_price();
					$product_sale_price    = $get_product->get_sale_price();
					$product_category_ids  = $get_product->get_category_ids();

					// Get theme base name
					$product_theme_slug_base = get_post_meta($product_id, 'theme_slug_base', true);

					// Check if product is in theme category
					foreach( $product_category_ids as $product_category_id ) {
						$product_category = get_cat_name( $product_category_id );
						$product_category = get_term_by( 'id', $product_category_id, 'product_cat' );

						if( strtolower( $product_category->name ) !== 'theme' ) {
							$skip = true;

							// Exit early on match
							break;
						}
					}

					// Skip to next iteration if this product is not a theme (i.e. Theme Club)
					if( ! empty( $skip ) ) {
						continue;
					}

					// Get product thumbnail
					$product_url   = get_post_permalink( $product_id );
					$product_image = get_the_post_thumbnail_url( $product_id );
				?>

					<div class="block-product">

						<a class="block-link" href="<?php echo $product_url ?>">

							<div class="block-header">

								<div class="block-media">
									<img src="<?php echo untrailingslashit( get_site_url() ) . '/wp-content/themes/tut/images/themes/pro/desktop/' . $product_theme_slug_base; ?>-desktop.jpg">
								</div>

							</div>
							<!-- .block-header -->

							<div class="block-body">

								<div class="block-text">
									<?php echo $product_post_excerpt; ?>
								</div>

							</div>
							<!-- .block-body -->

							<div class="block-footer block-flex">

								<div class="block-text block-name flex-col-2">
									<?php echo $product_post_title; ?>
								</div>

								<div class="block-text block-price flex-col-2">
									from $<?php echo $product_regular_price; ?>
								</div>

							</div>
							<!-- .block-footer -->

						</a>
						<!-- .block-link -->

					</div>
					<!-- .block-product -->

				<?php endforeach ?>

			</div>
			<!-- .block-products -->

		</div>

	</div>
</section>