<?php

// Setup content array
$items = array(
	array( 'icon' => 'tablet', 'title' => 'Animation',          'desc' => 'Create animated content so it slides in as the user scrolls down the page.'             ),
	array( 'icon' => 'tablet', 'title' => 'Buttons',            'desc' => 'Add buttons with a single click and easily link these to any webpage.'                  ),
	array( 'icon' => 'tablet', 'title' => 'Dividers',           'desc' => 'Make your content look great with dividing lines and even add a scroll to top divider!' ),
	array( 'icon' => 'tablet', 'title' => 'Featured Content',   'desc' => 'Create featured content with an image, title and description in just a few clicks.'     ),
	array( 'icon' => 'tablet', 'title' => 'Headings',           'desc' => 'Get the perfect look by adding titles anywhere. Just drag & drop!'                      ),
	array( 'icon' => 'tablet', 'title' => 'Images',             'desc' => 'Add images straight from your media library. It really couldn’t be any easier.'         ),
	array( 'icon' => 'tablet', 'title' => 'Notification Boxes', 'desc' => 'Add messages using the notification boxes and get your visitors attention.'             ),
	array( 'icon' => 'tablet', 'title' => 'Progress Bars',      'desc' => 'Keep your visitors updated with these beautiful bootstap progress bars.'                ),
	array( 'icon' => 'tablet', 'title' => 'Separators',         'desc' => 'Get the perfect page layout by adding the exact spacing you want.'                      ),
	array( 'icon' => 'tablet', 'title' => 'TinyMCE',            'desc' => 'You can still use the WordPress page editor to add any content you want!'               ),
	array( 'icon' => 'tablet', 'title' => 'Twitter Posts',      'desc' => 'Display twitter posts in just a single click. Just add the post link and your done.'    ),
	array( 'icon' => 'tablet', 'title' => 'Youtube & Vimeo',    'desc' => 'Show off your favourite videos with ease. Just add a video link and that’s it.'         ),
);
?>

<section class="container page-section page-section4 builder-section builder-section4">
	<div class="container-core">

		<div class="container-row builder-section4-row1">
			<h3 class="block-title">Our themes are feature packed!</h3>
		</div>

		<div class="container-row builder-section4-row2">

			<div class="block-features block-style1 block-grid grid-col-3 grid-gap-20 w800-grid-col-2 w480-grid-col-1">

			<?php foreach( $items as $item ): ?>

				<div class="block-icon block-style1 block-tall x9BF6FF">
					<h4 class="block-title"><?php echo $item['title']; ?></h4>
					<div class="block-text"><?php echo $item['desc']; ?></div>
					<div class="block-media"><i class="fas fa-<?php echo $item['icon']; ?>"></i></div>
				</div>

			<?php endforeach; ?>

			</div>

		</div>

	</div>
</section>