<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package ThinkUpThemes
 */

get_header(); ?>

		<?php
			// Get search query
			$title_search = get_search_query();

			// Trim if search query is long
			if (strlen($title_search) > 15) {
				$title_search = substr($title_search, 0, 12) . '...';
			}
		?>

			<?php if ( have_posts() ) : ?>

				<section class="container blog-posts">

					<div class="container-core">

						<div class="block-header block-flex">

							<div class="block-back">
								<a href="<?php echo untrailingslashit( get_home_url() ) ?>"><i class="far fa-arrow-left"></i> Back to blog</a>
							</div>

							<div class="block-category">
								<h1 class="block-title margin-0">Results: <?php echo $title_search; ?></h1>
							</div>

						</div>

						<div class="block-content">

							<div class="blog-grid block-grid grid-col-3 grid-gap-50 w800-grid-col-1">

								<?php while ( have_posts() ) : the_post(); ?>

									<?php get_template_part( 'content', 'search' ); ?>

								<?php endwhile; ?>

							</div>

						</div>

					</div>

				</section><div class="clearboth"></div>

				<?php thinkup_input_pagination(); ?>

			<?php else : ?>

				<?php get_template_part( 'no-results', 'search' ); ?>

			<?php endif; ?>

<?php get_footer(); ?>