"use strict";

/**
 * Companion JS class.
 */
class TUTGlobal {
	constructor () {
		/**
		 * Get time document is loaded.
		 */
		this.timeMS = new Date().getTime();

		// Add "Allow All" button on cookie selection page.
		var elButtonCookie       = '#cky-btn-settings';
		var elButtonCookieAccept = '#upify-cky-btn-accept';

		// Setup on page load.
		jQuery( window ).on(
			'load',
			this.setupGlobal
		);

		// Selector(s) - Select pricing option.
		var elSelectPricing = '.data-option-pricing';

		// Function(s) - Select pricing option.
		jQuery( document ).on(
			'click',
			elSelectPricing,
			this.selectPricing
		);
	}

	/**
	 * Setup global
	 */
	setupGlobal() {

		/**
		 * Declare classes
		 */
		var TG = window.TUTGlobal;

		// Get total download count
// DISABLED		TG.getDownloadCount();
	}

	/**
	 * Get theme download count
	 */
	getDownloadCount( api_endpoint = false, data = {} ) {

		/**
		 * Declare classes
		 */
		var TC = window.TUTComponents;

		// Construct data object
		var data = {
			'total': 1
		};

		// API endpoint
		var api_endpoint = TUT_VAR.siteurl + '/wp-json/tut/v1/test';

		// API Request
		var response = TC.callSite( api_endpoint, data );

		// Proceed when response is received
		response.done( function( response ) {
// No action is taken, setup for future use if needed
		});
	}

	/**
	 * Select pricing option
	 */
	selectPricing(e) {

		// Get option data
		var option = jQuery( this ).attr( 'data-option' );
//		var value  = jQuery( this ).val();

		// Assign selector variables
		var container       = jQuery( this ).closest( '.data-container' );
		var containerPrices = container.find( '.block-prices .block-price' );
		var buttonLink      = container.find( '.button-cart-link' );
		var target          = container.find( '.data-content .option-data[data-option="' + option + '"]' );

		// Get cart url
		var value = target.attr( 'data-value' );

		// Update "add to cart" button url
		buttonLink.attr( 'href', value );

		// Remove checkbox from all pricing options
		containerPrices.attr( 'data-value', 0 );

		// Ass checkbox to current pricing options
		jQuery( this ).attr( 'data-value', 1 );
	}
}
window.TUTGlobal = new TUTGlobal();