'use strict';

/**
 * Main JS class.
 */
class TUTComponents {
	constructor() {

		/**
		 * Get time document is loaded.
		 *
		 * @var {Number}
		 */
		this.timeMS = new Date().getTime();
	}

	/**
	 * API call to modify site data (add, delete, update).
	 */
	callSite( api_endpoint = false, data = {}, method = 'POST' ) {

		// Proceed only if endpoint passed
		if ( api_endpoint ) {

			// Ajax request to add new site
			var response = jQuery.ajax( {

				// Send data to API endpoint
				url        : api_endpoint,
				data       : JSON.stringify( data ),
				dataType   : 'json',
				method     : method,
				beforeSend : function() {
				},
			} );

			return response;
		}
	}
}

window.TUTComponents = new TUTComponents();