<?php
/**
 * Register Knowledge menu in admin area.
 *
 * @package ThinkUpThemes
 */


/* ----------------------------------------------------------------------------------
	Add Knowledge Menu to Admin
---------------------------------------------------------------------------------- */
function knowledge_custom_init() {
	$labels = array(
		'name'               => _x( 'Knowledge Base', 'post type general name' ),
		'singular_name'      => _x( 'Knowledge', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'knowledge' ),
		'add_new_item'       => 'Add New Knowledge',
		'edit_item'          => 'Edit Knowledge',
		'new_item'           => 'New Knowledge',
		'view_item'          => 'View Knowledge',
		'search_items'       => 'Search Knowledge',
		'not_found'          => 'No knowledge found',
		'not_found_in_trash' => 'No knowledge found in Trash',
		'parent_item_colon'  => '',
		'menu_name'          => 'Knowledge',
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'docs-old' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
//		'taxonomies'         => array('category', 'post_tag' ) // this is IMPORTANT
	);

	/* Register Knowledge menu */
	register_post_type( 'Knowledge', $args );

	/* Category - Initialise New Taxonomy Labels */
	$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name' ),
		'search_items'      => 'Search Categories',
		'all_items'         => 'All Categories',
		'parent_item'       => 'Parent Category',
		'parent_item_colon' => 'Parent Category:',
		'edit_item'         => 'Edit Categories',
		'update_item'       => 'Update Category',
		'add_new_item'      => 'Add New Category',
		'new_item_name'     => 'New Category Name',
	);

	// Category - Register custom taxonomy for Knowledge tags
	register_taxonomy( 'catknowledge', array( 'knowledge' ), array(
		'hierarchical' => true,
		'labels'       => $labels,
		'show_ui'      => true,
		'query_var'    => true,
		'rewrite'      => array( 'slug' => 'doc-section', ),
	));

	/* Tags - Initialise New Taxonomy Labels */
	$labels = array(
		'name'              => _x( 'Tags', 'taxonomy general name' ),
		'singular_name'     => _x( 'Tag', 'taxonomy singular name' ),
		'search_items'      => 'Search Types',
		'all_items'         => 'All Tags',
		'parent_item'       => 'Parent Tag',
		'parent_item_colon' => 'Parent Tag:',
		'edit_item'         => 'Edit Tags',
		'update_item'       => 'Update Tag',
		'add_new_item'      => 'Add New Tag',
		'new_item_name'     => 'New Tag Name',
	);

	// Tags - Register custom taxonomy for Knowledge tags
	register_taxonomy( 'tagknowledge', array( 'knowledge' ), array(
		'hierarchical' => true,
		'labels'       => $labels,
		'show_ui'      => true,
		'query_var'    => true,
		'rewrite'      => array( 'slug' => 'kb-tag', ),
	));

	/* Fixes redirect to 404 error template */
	flush_rewrite_rules();

//	  register_taxonomy('knowledge_category', 'knowledge',  array('hierarchical' => false, 'label' => 'Category','query_var'  => true, 'rewrite' => true));
}
add_action('init', 'knowledge_custom_init');


/* ----------------------------------------------------------------------------------
	Custom Knowledge Messages
---------------------------------------------------------------------------------- */
function knowledge_updated_messages( $messages ) {
global $post, $post_ID;

	$messages[ 'knowledge' ] = array(
		0 => '',
		1 => sprintf( 'Knowledge updated. <a href="%s">View knowledge</a>', esc_url( get_permalink( $post_ID ) ) ),
		2 => 'Custom field updated.',
		3 => 'Custom field deleted.',
		4 => 'Knowledge updated.',
		5 => isset($_GET[ 'revision' ]) ? sprintf( 'Knowledge restored to revision from %s', wp_post_revision_title( (int)

$_GET[ 'revision' ], false ) ) : false,
		6 => sprintf( 'Knowledge published. <a href="%s">View knowledge</a>', esc_url( get_permalink( $post_ID ) ) ),
		7 => 'Knowledge saved.',
		8 => sprintf( 'Knowledge submitted. <a target="_blank" href="%s">Preview knowledge</a>', esc_url( add_query_arg( 'preview',

'true', get_permalink( $post_ID ) ) ) ),
		9 => sprintf( 'Knowledge scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview knowledge</a>',
		  date_i18n( 'M j, Y @ G:i', strtotime( $post->post_date ) ), esc_url( get_permalink( $post_ID ) ) ),
		10 => sprintf( 'Knowledge draft updated. <a target="_blank" href="%s">Preview knowledge</a>', esc_url( add_query_arg( 'preview',

'true', get_permalink( $post_ID ) ) ) ),
	);
	return $messages;
}
add_filter( 'post_updated_messages', 'knowledge_updated_messages' );
