<?php
/**
 * Register Portfolio menu in admin area.
 *
 * @package ThinkUpThemes
 */


/* ----------------------------------------------------------------------------------
	Add Free Menu to Admin
---------------------------------------------------------------------------------- */

function free_custom_init() {

	$labels = array(
		'name'               => _x( 'Premium WordPress Themes', 'post type general name' ),
		'singular_name'      => _x( 'Free', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'free' ),
		'add_new_item'       => 'Add New Free',
		'edit_item'          => 'Edit Free',
		'new_item'           => 'New Free',
		'view_item'          => 'View Free',
		'search_items'       => 'Search Free',
		'not_found'          => 'No free found',
		'not_found_in_trash' => 'No free found in Trash',
		'parent_item_colon'  => '',
		'menu_name'          => 'Free',
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'free' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'excerpt',
			'custom-fields'
		),
	);

	// Register Free menu
	register_post_type( 'Free', $args );

  	// Fixes redirect to 404 error template
	flush_rewrite_rules();

	// Initialise New Taxonomy Labels
	$labels = array(
		'name'              => _x( 'Tags', 'taxonomy general name' ),
		'singular_name'     => _x( 'Tag', 'taxonomy singular name' ),
		'search_items'      => 'Search Types',
		'all_items'         => 'All Tags',
		'parent_item'       => 'Parent Tag',
		'parent_item_colon' => 'Parent Tag:',
		'edit_item'         => 'Edit Tags',
		'update_item'       => 'Update Tag',
		'add_new_item'      => 'Add New Tag',
		'new_item_name'     => 'New Tag Name',
	);

	// Register custom taxonomy for Free tags
	register_taxonomy( 'tagfree', array( 'free' ), array(
		'hierarchical' => true,
		'labels'       => $labels,
		'show_ui'      => true,
		'query_var'    => true,
		'rewrite'      => array( 'slug' => 'tag-free' ),
	));
}
add_action('init', 'free_custom_init');


/* ----------------------------------------------------------------------------------
	Custom Free Messages
---------------------------------------------------------------------------------- */

function free_updated_messages( $messages ) {
global $post, $post_ID;

	$messages[ 'free' ] = array(
		0 => '',
		1 => sprintf( 'Free updated. <a href="%s">View free</a>', esc_url( get_permalink( $post_ID ) ) ),
		2 => 'Custom field updated.',
		3 => 'Custom field deleted.',
		4 => 'Free updated.',
		5 => isset($_GET[ 'revision' ]) ? sprintf( 'Free restored to revision from %s', wp_post_revision_title( (int) $_GET[ 'revision' ], false ) ) : false,
		6 => sprintf( 'Free published. <a href="%s">View free</a>', esc_url( get_permalink( $post_ID ) ) ),
		7 => 'Free saved.',
		8 => sprintf( 'Free submitted. <a target="_blank" href="%s">Preview free</a>', esc_url( add_query_arg( 'preview', 'true', get_permalink( $post_ID ) ) ) ),
		9 => sprintf( 'Free scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview free</a>', date_i18n( 'M j, Y @ G:i', strtotime( $post->post_date ) ), esc_url( get_permalink( $post_ID ) ) ),
		10 => sprintf( 'Free draft updated. <a target="_blank" href="%s">Preview free</a>', esc_url( add_query_arg( 'preview', 'true', get_permalink( $post_ID ) ) ) ),
	);

	return $messages;
}
add_filter( 'post_updated_messages', 'free_updated_messages' );

