<?php
/**
 * Setup theme functions for Minamaze.
 *
 * @package ThinkUpThemes
 */

// Declare latest theme version
$GLOBALS['thinkup_theme_version'] = '1.0.5';

// Setup content width
function thinkup_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'thinkup_content_width', 1200 );
}
add_action( 'after_setup_theme', 'thinkup_content_width', 0 );

// Declare latest theme version
//$GLOBALS['thinkup_trial_cta'] = 'Join For Free';
$GLOBALS['thinkup_trial_cta'] = 'Start For Free';


//----------------------------------------------------------------------------------
//	Add Theme Options Panel & Assign Variable Values
//----------------------------------------------------------------------------------

// Add Theme Options Features.
require_once( get_template_directory() . '/admin/main/options/00.theme-setup.php' );
require_once( get_template_directory() . '/admin/main/options/03.header.php' );
require_once( get_template_directory() . '/admin/main/options/04.footer.php' );
require_once( get_template_directory() . '/admin/main/options/05.blog.php' );
require_once( get_template_directory() . '/admin/main/options/9.data-testimonial.php' );
require_once( get_template_directory() . '/admin/main/options/9.api-endpoints.php' );

// Add WooCommerce functions if WooCommerce plugin is activated.
if ( class_exists( 'Woocommerce' ) ) {
	require_once( get_template_directory() . '/admin/main/options/13.woocommerce.php' );
}

//----------------------------------------------------------------------------------
//	Assign Theme Specific Functions
//----------------------------------------------------------------------------------

// Setup theme features, register menus and scripts.
if ( ! function_exists( 'thinkup_themesetup' ) ) {

	function thinkup_themesetup() {

		// Load required files
		require_once ( get_template_directory() . '/lib/functions/template-tags.php' );

		// Load CPT's
		require_once ( get_template_directory() . '/lib/custom-posts/free/register-free.php' );
//		require_once ( get_template_directory() . '/lib/custom-posts/knowledge/register-knowledge.php' );

		// Add default theme functions.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'post-formats', array( 'gallery', 'image', 'video', 'audio', 'status', 'quote', 'link', 'chat' ) );
		add_theme_support( 'title-tag' );

		// Add support for custom background
		add_theme_support( 'custom-background' );

		// Add support for custom header
		$thinkup_header_args = apply_filters( 'thinkup_custom_header', array( 'height' => 200, 'width'  => 1600, 'header-text' => false, 'flex-height' => true ) );
		add_theme_support( 'custom-header', $thinkup_header_args );

		// Add support for custom logo
		add_theme_support( 'custom-logo', array( 'height' => 90, 'width' => 200, 'flex-width' => true, 'flex-height' => true ) );

		// Add WooCommerce functions.
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Add excerpt support to pages.
		add_post_type_support( 'page', 'excerpt' );

		// Register theme menu's.
		register_nav_menus( array( 'pre_header_menu' => __( 'Pre Header Menu', 'minamaze' ) ) );
		register_nav_menus( array( 'header_menu'     => __( 'Primary Header Menu', 'minamaze' ) ) );
		register_nav_menus( array( 'sub_footer_menu' => __( 'Footer Menu', 'minamaze' ) ) );
	}
}
add_action( 'after_setup_theme', 'thinkup_themesetup' );


//----------------------------------------------------------------------------------
//	Register Front-End Styles And Scripts
//----------------------------------------------------------------------------------

function thinkup_frontscripts() {

	global $thinkup_theme_version;

	// Add 3rd party stylesheets - Prefixed to prevent conflict between library versions
//	wp_enqueue_style( 'thinkup-normalize', get_template_directory_uri() . '/lib/extentions/normalize/normalize.css', '', '8.0.1' );
//	wp_enqueue_style( 'thinkup-uikit', get_template_directory_uri() . '/lib/extentions/uikit/css/uikit.min.css', '', '3.6.22' );

	// Add 3rd party Font Packages
//	wp_enqueue_style( 'font-awesome-pro', get_template_directory_uri() . '/lib/extentions/fontawesome-pro/css/all.css', '', '5.15.3' );

	// Add 3rd party scripts - Prefixed to prevent conflict between library versions
	wp_enqueue_script( 'thinkup-uikit', get_template_directory_uri() . '/lib/extentions/uikit/js/uikit.min.js', array( 'jquery' ), '3.6.22', 'true' );

	// Add theme stylesheets
//	wp_enqueue_style( 'thinkup-app', get_template_directory_uri() . '/custom-css/app.css', '', $thinkup_theme_version );
	wp_enqueue_style( 'thinkup-style', get_stylesheet_uri(), '', $thinkup_theme_version );

	// Add theme scripts
	wp_enqueue_script( 'thinkup-components', get_template_directory_uri() . '/lib/scripts/components.js', array( 'jquery' ), $thinkup_theme_version, 'true' );
	wp_enqueue_script( 'thinkup-global', get_template_directory_uri() . '/lib/scripts/global.js', array( 'jquery' ), $thinkup_theme_version, 'true' );
	wp_enqueue_script( 'thinkup-frontend', get_template_directory_uri() . '/lib/scripts/main-frontend.js', array( 'jquery' ), $thinkup_theme_version, 'true' );

	// Localize scripts
	wp_localize_script('thinkup-global', 'TUT_VAR', array( 'siteurl' => untrailingslashit( get_site_url() ) ) );

	// Register WooCommerce (theme specific) stylesheets
//	wp_register_style( 'thinkup-woocommerce', get_template_directory_uri() . '/styles/woocommerce/css/woocommerce.css', '', $thinkup_theme_version );
//	wp_register_style( 'thinkup-woocommerce-theme', get_template_directory_uri() . '/styles/woocommerce/css/woocommerce-theme.css', '', $thinkup_theme_version );

	// Add comments reply script
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

//	if ( is_page_template( 'templates/template-pricing.php' ) ) {
//		wp_enqueue_script( 'jquery-masonry' );
//	}
}
add_action( 'wp_enqueue_scripts', 'thinkup_frontscripts', 10 );


//----------------------------------------------------------------------------------
//	Register Theme Widgets
//----------------------------------------------------------------------------------

function thinkup_widgets_init() {

	// Register default sidebar
	register_sidebar( array(
		'name'          => 'Sidebar',
		'id'            => 'sidebar-1',
		'before_widget' => '<aside class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	// Register footer sidebars
    register_sidebar( array(
        'name'          => 'Footer Widget Area 1',
        'id'            => 'footer-w1',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );

    register_sidebar( array(
        'name'          => 'Footer Widget Area 2',
        'id'            => 'footer-w2',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );

    register_sidebar( array(
        'name'          => 'Footer Widget Area 3',
        'id'            => 'footer-w3',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );

    register_sidebar( array(
        'name'          => 'Footer Widget Area 4',
        'id'            => 'footer-w4',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );

    register_sidebar( array(
        'name'          => 'Footer Widget Area 5',
        'id'            => 'footer-w5',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );

    register_sidebar( array(
        'name'          => 'Footer Widget Area 6',
        'id'            => 'footer-w6',
        'before_widget' => '<aside class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="footer-widget-title"><span>',
        'after_title'   => '</span></h3>',
    ) );
 }
add_action( 'widgets_init', 'thinkup_widgets_init' );

/* Delay autop to avoid shortcode issues */
remove_filter( 'the_content', 'wpautop' );
add_filter( 'the_content', 'wpautop' , 12);

function jf_shortcode_cta_body( $atts = array(), $content = null ) {

	// set up default parameters
	extract(shortcode_atts(array(
		'style'       => '1',
		'id'          => '',
		'title'       => 'Collect feedback with <strong>WeSellTalent</strong>',
		'text'        => 'WeSellTalent helps your business increase profits and reduce risk by improving your customer experience',
		'button_text' => 'Start For Free',
		'button_link' => 'https://app.weselltalent.com/register'
	), $atts));

	// Construct shortcode
	$content .= "<div class=\"block-aida block-style$style\" id=\"$id\">";
	$content .= "<div class=\"block-aida-core\">";

	$content .= "<div class=\"block-body\">";
	$content .= "<p class=\"block-title\">$title</p>";
	$content .= "<div class=\"block-text\">";
	$content .= "<p>$text</p>";
	$content .= "</div>";
	$content .= "<div class=\"block-buttons\">";
	$content .= "<button class=\"button button-link button-s button-v1 button-cart border-radius-5 margin-0\" data-upify-event=\"button-cta-trial-aida\"><a href=\"$button_link\">$button_text</a></button>";
	$content .= "</div>";
	$content .= "</div>";

	$content .= "<div class=\"block-footer\">";
	$content .= "<div class=\"block-text\">";
	$content .= "<p class=\"block-flex block-flex-center flex-row-gap-5 flex-column-gap-20 w480-block-flex-column\">";
	$content .= "<span class=\"hidden-display-OFF\"><i class=\"fal fa-check\"></i>Setup in seconds</span>";
	$content .= "<span><i class=\"fal fa-check\"></i>No credit card required</span>";
	$content .= "</p>";
	$content .= "</div>";
	$content .= "</div>";

	$content .= "</div>";
	$content .= "</div>";

	// Replace linebreaks from content
	$content = str_replace('<br>', '', $content);

	// Output shortcode
	return $content;
}
add_shortcode('jf_sc_cta_body', 'jf_shortcode_cta_body');



// function my_formatter($content) {
//        $new_content = '';
//        $pattern_full = '{(\[raw\].*?\[/raw\])}is';
//        $pattern_contents = '{\[raw\](.*?)\[/raw\]}is';
//        $pieces = preg_split($pattern_full, $content, -1, PREG_SPLIT_DELIM_CAPTURE);

//        foreach ($pieces as $piece) {
//                if (preg_match($pattern_contents, $piece, $matches)) {
//                        $new_content .= $matches[1];
//                } else {
//                        $new_content .= wptexturize(wpautop($piece));
//                }
//        }

//        return $new_content;
// }

//remove_filter('the_content', 'wpautop');
//remove_filter('the_content', 'wptexturize');

//add_filter('the_content', 'my_formatter', 99);

//remove_filter( 'the_content', 'wpautop' );
//add_filter( 'the_content', 'wpautop' , 99 );
//add_filter( 'the_content', 'shortcode_unautop', 100 );

//remove_filter('the_content', 'wpautop');
//add_filter('the_content', 'wpautop', 12);

function tut_shortcode_image( $atts = array() ) {

	// set up default parameters
	extract(shortcode_atts(array(
		'thumb' => '',
		'image' => '',
		'title' => '',
		'alt' => ''
	), $atts));

	// Output image
	return "<div class=\"block-lightbox uk-margin-medium\" uk-lightbox=\"\" uk-tooltip=\"title: Click to view full size; pos: top-center; animation: uk-animation-fade; duration: 300\" aria-expanded=\"false\" tabindex=\"0\">
			<a href=\"$image\"><i class=\"fal fa-expand-arrows\"></i><img src=\"$thumb\" alt=\"$alt\"></a>
			</div>";
}
add_shortcode('image', 'tut_shortcode_image');


function tut_shortcode_notification( $atts = array(), $content = null ) {

	// Assign default variable values
	$output = null;

	// set up default parameters
	extract(shortcode_atts(array(
		'type' => '',
		'image' => '',
		'title' => ''
	), $atts));

	// Construct shortcode
	$output .= "<div class=\"block-notification block-style1 block-info margin-top-40\">";
	$output .= "<div class=\"block-notification-core\">";
	$output .= "<div class=\"block-text\">$content</div>";
	$output .= "</div>";
	$output .= "</div>";

	// Replace linebreaks from content
	$output = str_replace('<br>', '', $output);

	// Output shortcode
	return $output;
}
add_shortcode('notification', 'tut_shortcode_notification');








function tut_shortcode_divider( $atts = array(), $content = null ) {

	// Assign default variable values
	$output = null;

	// Construct shortcode
	$output .= "<hr class=\"uk-divider-small\">";

	// Replace linebreaks from content
	$output = str_replace('<br>', '', $output);

	// Output shortcode
	return $output;
}
add_shortcode('divider', 'tut_shortcode_divider');


























// Source - https://dzone.com/articles/remove-automatic-paragraphs
function tut_shortcode_remove_autop($content) {
	$new_content = '';
	$pattern_full = '{(\[raw\].*?\[/raw\])}is';
	$pattern_contents = '{\[raw\](.*?)\[/raw\]}is';
	$pieces = preg_split($pattern_full, $content, -1, PREG_SPLIT_DELIM_CAPTURE);

	foreach ($pieces as $piece) {
		if (preg_match($pattern_contents, $piece, $matches)) {
			$new_content .= $matches[1];
		} else {
			$new_content .= wptexturize(wpautop($piece));
		}
	}
	return $new_content;
}

add_filter('the_content', 'tut_shortcode_remove_autop', 99);

//Remove Gutenberg Block Library CSS from loading on the frontend
function smartwp_remove_wp_block_library_css(){
    wp_dequeue_style( 'wp-block-library' );
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_dequeue_style( 'wc-block-style' ); // Remove WooCommerce block CSS
}
add_action( 'wp_enqueue_scripts', 'smartwp_remove_wp_block_library_css', 100 );


//----------------------------------------------------------------------------------
//	Update modified date when scheduled post is published
//----------------------------------------------------------------------------------

// Scheduled posts should update modified date when published
function update_modified_date_to_post_date( $post ) {
    $updated_data = [
        'ID'                => $post->ID,
        'post_modified'     => $post->post_date,
        'post_modified_gmt' => $post->post_date_gmt
    ];
    wp_update_post( $updated_data );
}
add_action( 'future_to_publish', 'update_modified_date_to_post_date', 10, 1 );







// Remove default unused stylesheets / scripts
function disable_classic_theme_styles() {
	wp_deregister_script('wp-mediaelement');
	wp_deregister_style('wp-mediaelement');
    wp_deregister_style('classic-theme-styles');
    wp_dequeue_style('classic-theme-styles');
}
add_filter('wp_enqueue_scripts', 'disable_classic_theme_styles', 100);

add_filter( 'jetpack_sharing_counts', '__return_false', 99 );
add_filter( 'jetpack_implode_frontend_css', '__return_false', 99 );







// function dolly_css() {

// 	// Assign default variable values
// 	$images = array();

// 	// Query images
// 	$args_images = array(
// 		'post_type'      => 'attachment',
// 		'post_mime_type' => 'image',
// 		'post_status'    => 'inherit',
// 		'posts_per_page' => - 1
// 	);
// 	$query_images = new WP_Query( $args_images );

// 	// Query images
// 	$args_posts = array(
// 		'post_type'      => 'post',
// 		'post_status'    => 'publish',
// 		'posts_per_page' => - 1
// 	);
// 	$query_posts = new WP_Query($args_posts);

// 	// Get all images
// 	$count = 0;

// 	foreach ( $query_images->posts as $image ) {

// 		$images[$count]['title'] = $image->post_title;
// 		$images[$count]['url']   = wp_get_attachment_url( $image->ID );

// 		$count++;
// 	}

// //	print_r($images);

// 	// Get all posts
// 	$count = 0;

// 	while($query_posts->have_posts()) {

// 		$query_posts->the_post();

// 		$content = get_the_content();
// 		$content = apply_filters('the_content', $content);

// 		$posts[$count]['title']    = get_the_title();
// 		$posts[$count]['featured'] = get_the_post_thumbnail_url();
// //		$posts[$count]['featured'] = basename ( get_the_post_thumbnail_url() );
// 		$posts[$count]['content']  = get_the_content();

// 		$count++;
// 	}

// //	print_r($posts);

// 	// Get images attached by post title
// 	$count = 0;

// 	foreach( $images as $image ) {

// 		$image_url = $image['url'];

// 		foreach( $posts as $post ) {

// 			$title    = $post['title'];
// 			$featured = $post['featured'];
// 			$content  = $post['content'];

// //			if( strpos($featured, $image ) !== false ) {
// //				$image_keep[$count]['title'] = $title;
// //				$image_keep[$count]['image'] = $image;
// //
// //				$count++;
// //			}

// 			if( str_contains($featured, $image_url) || str_contains($content, $image_url) ) {

// 				$image_keep[$count]['post']  = $title;
// 				$image_keep[$count]['image'] = $image_url;

// //				$image_keep[$count_1]['title'] = $title;
// //				$image_keep[$count_1]['image'] = $image;

// 				$count++;
// 			}
// 		}
// 	}

// 	print_r( $image_keep );

// 	// Reset image array
// //	foreach( $images as $key => $value) {
// //
// //		if( in_array( $value, $image_keep ) ) {
// //			unset($images[$key]);
// //		}
// //	}

// //	print_r( array_values( array_unique( $images ) ) );

// //	foreach( $images as $image ) {
// //		$images_id[] = attachment_url_to_postid( $image );
// //	}

// //	print_r( $images_id );

// //	foreach( $images_id as $image_id ) {
// //		wp_delete_attachment( $image_id );
// //	}

// //	print_r( array_values( array_unique( $image_keep ) ) );
// //	print_r( array_values( array_unique( $image_delete ) ) );

// }
//add_action( 'admin_head', 'dolly_css' );
