<?php
/**
 * The template for displaying Archive pages.
 *
 * @package ThinkUpThemes
 */

get_header(); ?>

			<?php
				$taxonomy = get_queried_object();
			?>

			<?php if( have_posts() ): ?>

				<section class="container blog-posts">

					<div class="container-core">

						<div class="block-header block-flex">

							<div class="block-back">
								<a href="<?php echo untrailingslashit( get_home_url() ) ?>"><i class="far fa-arrow-left"></i> Back to blog</a>
							</div>

							<div class="block-category">
								<h1 class="block-title margin-0"><?php echo $taxonomy->name; ?></h1>
							</div>

						</div>

						<div class="block-content">

							<div class="blog-grid block-grid grid-col-3 grid-gap-50 w800-grid-col-1">

							<?php while( have_posts() ): the_post(); ?>

								<div class="blog-grid-item element<?php // thinkup_input_stylelayout(); ?>">

								<article id="post-<?php the_ID(); ?>" <?php post_class('blog-article'); ?>>

									<header class="entry-header<?php // thinkup_input_stylelayout_class1(); ?>">
										<?php thinkup_input_blogimage(); ?>
									</header>

									<div class="entry-content<?php // thinkup_input_stylelayout_class2(); ?>">
										<?php thinkup_input_blogmeta(); ?>
										<?php thinkup_input_blogtitle(); ?>
										<?php thinkup_input_blogtext(21); ?>
										<?php // thinkup_input_readmore(); ?>
									</div>

								<div class="clearboth"></div>
								</article><!-- #post-<?php get_the_ID(); ?> -->

								</div>

							<?php endwhile; ?>

							</div>

						</div>

					</div>

				</section><div class="clearboth"></div>

				<?php thinkup_input_pagination(); ?>

			<?php else: ?>

				<?php get_template_part( 'no-results', 'archive' ); ?>

			<?php endif; wp_reset_query(); ?>

<?php get_footer() ?>