<?php
/**
 * Custom styling functions.
 *
 * @package ThinkUpThemes
 */

//----------------------------------------------------------------------------------
//	CONSTRUCT DATA ARRAY FOR TESTIMONIALS
//----------------------------------------------------------------------------------

// Build testimonial data array
function thinkup_data_testimonials(
	$id = null
) {

	// Construct testimonial array
	$output = array(
		array(
			'id'   => '316496601823204',
			'date' => '14/11/2013',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/316496601823204',
			'text' => 'Great work and excellent support. I recommend 100% Think Up Themes.',
		),
		array(
			'id'   => '321306938008837',
			'date' => '28/11/2013',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/321306938008837',
			'text' => 'Amazing theme and the best support I\'ve ever receive, special thanks to Afzaal for the kindness and time he took helping me! Cheers from Mexico',
		),
		array(
			'id'   => '321198048019726',
			'date' => '28/11/2013',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/321198048019726',
			'text' => 'Thanks so much to the team, and especially Afzaal, for providing such awesome support with the theme that I purchased. I will definitely back to order more - most impressive after sales support I have ever experienced!',
		),
		array(
			'id'   => '327596740713190',
			'date' => '16/12/2013',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/327596740713190',
			'text' => 'I just had a problem (due to a set up error I made) and contacted support , support responded quickly with a correct diagnosis and the problem was totally resolved within minutes. Thank you !!',
		),
		array(
			'id'   => '334654006674130',
			'date' => '04/01/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/334654006674130',
			'text' => 'Want to get the best support possible for wordpress themes then don\'t use anyone else. I have had so much help and assistance getting my new site up with Sticker and Afzaal never once made me feel like I was an idiot not like other support people have. AAA+ Rating from me.',
		),
		array(
			'id'   => '341295139343350',
			'date' => '22/01/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/341295139343350',
			'text' => 'Fantastic support. I don\'t know if it could be better. If you are looking for a WP theme/partner, look no further. [And a special thank you to Afzaal].',
		),
		array(
			'id'   => '349011311905066',
			'date' => '10/02/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/349011311905066',
			'text' => 'Just started using the engrave theme today for our stores website and we love it. The support is excellent and the features are easy enough. It takes some getting used to but after playing around for about an hour I got most of it figure out and can\'t wait to keep plugging away!',
		),
		array(
			'id'   => '354033501402847',
			'date' => '22/02/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/354033501402847',
			'text' => 'ThinkUp has both, outstanding templates and support. I am very happy and satisfied with my purchase. Keep up the good work! Congratulations!!!',
		),
		array(
			'id'   => '353953391410858',
			'date' => '22/02/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/353953391410858',
			'text' => 'After the installation of a theme, I had a problem with a plugin. I opened a ticket on the support. I had contact with a professional person worried about my request. The problem was a little complicated and required quite a lot of exchanges which were very quickly realized. Thank you for your professionalism and speed of processing.',
		),
		array(
			'id'   => '355848981221299',
			'date' => '27/02/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/355848981221299',
			'text' => 'A great team behind great themes! thanks for your fast and useful support to solve the little issues while working with your product 🙂',
		),
		array(
			'id'   => '356297514509779',
			'date' => '28/02/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/356297514509779',
			'text' => 'I just wanted to send a quick message to you and say thank you for developing a great set of themes.  I have been working with Misteek for just over a week now and I couldn\'t be happier.  The slider is amazing.  The options panel is user friendly.  I have bought my fair share of themes over the last 5 years and yours ranks up there with the best of them. Keep up the good work!',
		),
		array(
			'id'   => '364059940400203',
			'date' => '20/03/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/364059940400203',
			'text' => 'Think Up Themes has provided great support!  Not only did they respond quickly to tickets but they even added features I wanted.  They also offered to help with a WordPress that wasn\'t even their problem.  And the theme is really cool!',
		),
		array(
			'id'   => '367876620018535',
			'date' => '30/03/2014',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/367876620018535',
			'text' => 'Great customer service experience with these guys! I am a non-technical guy and needed a lot of hand-holding. I can\'t say I\'ve ever had better service anywhere online than with Afzaal from Think Up Themes. I highly recommend their services!',
		),
		array(
			'id'   => '759430660863127',
			'date' => '16/11/2016',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/759430660863127',
			'text' => 'Thanks for the great support today with issue now resolved. Very friendly and a strong desire to help find a solution. It\'s reassuring to know this level of support is available. Thanks very much!',
		),
		array(
			'id'   => '766839870122206',
			'date' => '29/11/2016',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/766839870122206',
			'text' => 'Great support from these guys. Had a few issues and got very detailed response.',
		),
		array(
			'id'   => '779143018891891',
			'date' => '19/12/2016',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/779143018891891',
			'text' => 'Excellent support! I had some issues that were solved with a very detailed explanation of what to do to fix them. I recommend ThinkUpThemes if you\'re looking for a WordPress template.',
		),
		array(
			'id'   => '831741413632051',
			'date' => '21/03/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/831741413632051',
			'text' => 'I have been with ThinkupThemes for a couple of years now and use a number of themes through my annual subscription. It is well worth the affordable annual fee, and when you do need to reach out to support they are always there to help!',
		),
		array(
			'id'   => '846693668803492',
			'date' => '13/04/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/846693668803492',
			'text' => 'Super Theme und super Service!!!',
		),
		array(
			'id'   => '850394965100029',
			'date' => '18/04/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/850394965100029',
			'text' => 'Just to commend the thinkup themes support for swiftly resolving the issues I raised with my theme. I recommend you to everyone who cares about great theme with support for great performance. Hi five!',
		),
		array(
			'id'   => '865041126968746',
			'date' => '13/05/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/865041126968746',
			'text' => 'It\'s always nice to work with the people of ThinkUpThemes. Very helping and and useful support i get.Thx',
		),
		array(
			'id'   => '890172141122311',
			'date' => '25/06/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/890172141122311',
			'text' => 'Thanks guys for your support good to deal with.',
		),
		array(
			'id'   => '883103991829126',
			'date' => '13/07/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/883103991829126',
			'text' => 'I\'d like to take a moment and thank Think Up Themes for helping me publish a modern and professional looking website. The templet I used, Consulting Pro, is beautiful and clean. I\'m no designer or coder, so having the easy to use page builder was great. When I had questions about certain features of the design and needed help, your support team always responded quickly and provided instructions clearly. One of your support administrators, Afzaal, was incredibly helpful and patient when helping me with some questions I had. Thank you for helping me build a great site!',
		),
		array(
			'id'   => '919377944868397',
			'date' => '15/08/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/919377944868397',
			'text' => 'Very nice variety with courteous, prompt support. Many thanks to Think Up Themes!',
		),
		array(
			'id'   => '953556561450535',
			'date' => '25/10/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/953556561450535',
			'text' => 'I posted earlier in the week out of frustration as I had a problem with page builder - but I have to post again now to say thank you to ThinkUpThemes support for solving my problem.  Thank you.',
		),
		array(
			'id'   => '956622701143921',
			'date' => '01/11/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/956622701143921',
			'text' => 'Best theme ... Best SUPPORT!!! ❤',
		),
		array(
			'id'   => '957792751026916',
			'date' => '03/11/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/957792751026916',
			'text' => 'Great job on the support side! Thanks guys!',
		),
		array(
			'id'   => '10155750813006772',
			'date' => '07/11/2017',
			'url'  => 'https://www.facebook.com/dayledermatis/posts/10155750813006772',
			'text' => 'Shoutout to Think Up Themes, makers of my website theme, Minamaze Pro. I\'ve been dealing with a couple of weird website issues and they\'ve been super-responsive, as well as patient with non-techie me. One problem down, one to go!',
		),
		array(
			'id'   => '961298764009648',
			'date' => '10/11/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/961298764009648',
			'text' => 'Thank you for the support on my sidebars problem.  I had a widget that also did sidebars and when this widget was deactivated, I was able to use sidebars.  Much appreciated your support.',
		),
		array(
			'id'   => '964557637017094',
			'date' => '16/11/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/964557637017094',
			'text' => 'Thanks for great support, i am very grateful!',
		),
		array(
			'id'   => '937364943069697',
			'date' => '21/11/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/937364943069697',
			'text' => 'What an awesome customer service experience with Robert! We\'ve been DIYing (how appropriate) our site for quite some time (and frustrations) and recently purchased Experon Pro. I had expected a message back for a support ticket I submitted, but the Skype tutorial I received from Robert was exactly what I needed. Yes, somebody to hold my hand!. Robert was patient, professional, informative and kind and made website building look way too easy! Honestly, no $ amount could equate to the value I received through customer service. Five stars!!!!! Thanks Robert!',
		),
		array(
			'id'   => '972873356185522',
			'date' => '02/12/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/972873356185522',
			'text' => 'I had a small problem with installing to Melos (Pro) in WordPress that I could not solve myself was written for ThinkUpThemes Support via a ticket. Mr. Afzaal answered back to me and he fixed the problem very quickly. Thank you for your help and good service.',
		),
		array(
			'id'   => '978422662297258',
			'date' => '13/12/2017',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/978422662297258',
			'text' => 'Great themes and great support!  I\'m a big fan.',
		),
		array(
			'id'   => '1076094525863404',
			'date' => '08/07/2018',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1076094525863404',
			'text' => 'Their support give me amazing, quick, kind, professional help with my wordpress technical problem. Thanks a lot!',
		),
		array(
			'id'   => '1111178322355024',
			'date' => '14/07/2018',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1111178322355024',
			'text' => 'Manoj was so helpful via email when I just couldn\'t find the setting that changed a look on the website I was working on. So nice to get a timely reply. Thank You!',
		),
		array(
			'id'   => '1081402955332561',
			'date' => '15/07/2018',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1081402955332561',
			'text' => 'Thanks Imran, and Thinkup, for good support via email! -HS',
		),
		array(
			'id'   => '1273659356106919',
			'date' => '20/02/2019',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1273659356106919',
			'text' => 'The Customer Support team at Think Up Themes is FANTASTIC!',
		),
		array(
			'id'   => '1283414798464708',
			'date' => '07/03/2019',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1283414798464708',
			'text' => 'This is a review for Think Up Themes. The time difference seems to create delays, however the service proves to be spot on. They do take you through to where you need to be to get moving forward when things are not working for you. In the end, although, I was shooting for a refund until I could have resolution, the ticket support staff helped via Skype, took as much time as needed even with a busy schedule. I thank Robert and all who were involved in serving the process of resolution through this support ticket.',
		),
		array(
			'id'   => '1456561894483330',
			'date' => '14/10/2019',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1456561894483330',
			'text' => 'These guys rock - I use their themes pretty much exclusively as I have never found the need to go elsewhere, I can develop everything I need based on Thinkup products. Customer service is excellent although seldom used because themes are simple to customize and robust in use.  Frankly ideal.',
		),
		array(
			'id'   => '1487428828063303',
			'date' => '12/11/2019',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1487428828063303',
			'text' => 'Huge thanks to Manoj from the support team for efficiently and helpfully dealing with a tech issue to do with my theme. I have very little tech knowledge, but was not made to feel silly and was clearly directed to how to solve the problem',
		),
		array(
			'id'   => '1999032263569621',
			'date' => '15/06/2021',
			'url'  => 'https://www.facebook.com/ThinkUpThemes/posts/1999032263569621',
			'text' => 'Just to say thank you! I am using you template for years and everytime I had some issues with some conflicting plugins I get fast help from your support. Bravo! 👍',
		),
	);

	return $output;
}

// Get testimonial
function thinkup_data_testimonials_get(
	string $id = null,
	int $word_min = null,
	int $word_max = null,
	int $max = null,
	array $exclude = null
) {

	// Assign default variable values
	$testimonial = (array) null;

	// Get testimonials data
	$testimonials = thinkup_data_testimonials($id);

	// Reverse array
	$testimonials = array_reverse($testimonials);

	// Remove all with length < word_min
	if( ! empty( $word_min ) ) {

		foreach( $testimonials as $key => $value ) {

			// Extract testimonial data
			$testimonial_text = (string) (isset($value['text']) ? $value['text'] : null);

			if( str_word_count( $testimonial_text ) <= $word_min ) {
				unset($testimonials[$key]);
			}
		}
	}

	// Truncate all with length > word_max
	if( ! empty( $word_max ) ) {

		foreach( $testimonials as $key => $value ) {

			// Extract testimonial data
			$testimonial_text = (string) (isset($value['text']) ? $value['text'] : null);

			if( str_word_count( $testimonial_text ) >= $word_max ) {
				$testimonials[$key]['text'] = implode(' ', array_slice(explode(' ', $testimonial_text), 0, $word_max)) . '...';;
			}
		}
	}

	// Return single testimonial if ID is set
	if( ! empty( $id ) ) {

		foreach( $testimonials as $key => $value ) {

			// Extract testimonial data
			$testimonial_id = (string) (isset($value['id']) ? $value['id'] : null);

			// Check if testimonial ID is set (exit early on match)
			if( ! empty( $testimonial_id ) && $id == $testimonial_id ) {
				$testimonial = $value;
				break;
			}
		}
	}

	// Remove specific testimonials if needed
	if( ! empty( $exclude ) ) {

		foreach( $testimonials as $key => $value ) {

			// Extract testimonial data
			$testimonial_id = (string) (isset($value['id']) ? $value['id'] : null);

			// Check if testimonial ID is set (exit early on match)
			if( ! empty( $testimonial_id ) && in_array($testimonial_id, $exclude) ) {
				unset($testimonials[$key]);
			}
		}
	}

	// Remove specific testimonials if needed
	if( ! empty( $exclude ) ) {

		foreach( $testimonials as $key => $value ) {

			// Extract testimonial data
			$testimonial_id = (string) (isset($value['id']) ? $value['id'] : null);

			// Check if testimonial ID is set (exit early on match)
			if( ! empty( $testimonial_id ) && in_array($testimonial_id, $exclude) ) {
				unset($testimonials[$key]);
			}
		}
	}

	// Get first n items if max is set
	if( ! empty( $max ) ) {
		$testimonials = array_slice($testimonials, 0, $max, true);
	}

	// Return single testimonial if set
	if( ! empty( $testimonial ) ) {
		return $testimonial;
	}

	return $testimonials;
}





















?>