<?php
/**
 * API endpoints.
 *
 * @package ThinkUpThemes
 */

//----------------------------------------------------------------------------------
//	CONSTRUCT API ENDPOINTS
//----------------------------------------------------------------------------------

add_action( 'rest_api_init', function () {
	register_rest_route( 'tut/v1', 'test', array(
		'methods'             => 'POST',
		'callback'            => 'thinkup_api_wptally_get',
		'permission_callback' => '__return_true',
	));
});


//----------------------------------------------------------------------------------
//	GET THEME DOWNLOAD COUNT
//----------------------------------------------------------------------------------

function thinkup_api_wptally_get(
	$request
) {

	// Assign default variable values
	$data_final      = (array) null;
	$downloads_total = (int)   null;

	// Get API data
	$data = $request->get_body();     // Get data in json format
	$data = json_decode($data, true); // Convert json array to PHP array

	// Data from array
	$group = (int) (isset($data['group']) ? $data['group'] : null);
	$total = (int) (isset($data['total']) ? $data['total'] : null);

	// Construct arguments for API call
	$args = array(
		'timeout' => 5
	);

	// Make API call to WP Tally website
	$response = wp_remote_get( 'http://wptally.com/api/thinkupthemes', $args );

	// Get body content from response
	$response = wp_remote_retrieve_body( $response ); // Get response in json format
	$response = json_decode($response, true);         // Convert json array to PHP array

	// Loop through each theme and get download count by theme
	$response_themes = $response['themes'];

	// Get download count by theme
	if( is_array( $response_themes ) && ! empty( $response_themes ) ) {

		// Loop through each theme
		foreach($response_themes as $key => $value) {

			// Extract theme data
			$name      = (string) (isset($value['name'])      ? $value['name']      : null);
			$downloads = (int)    (isset($value['downloads']) ? $value['downloads'] : null);

			if( ! empty( $total ) ) {

				// Get total download count
				$downloads_total = $downloads_total + $downloads;

				// Update total download count
				$data_final['total'] = $downloads_total;

			} else {

				// Construct data aray
				$data_final['name']      = $name;
				$data_final['downloads'] = $downloads;
			}
		}
	}

	// Return final data array
	return $data_final;
}

?>