<?php
/**
 * Custom styling functions.
 *
 * @package ThinkUpThemes
 */

//----------------------------------------------------------------------------------
//	REMOVE DEFAULT WOOCOMMERCE STYLING / REPLACE WITH THEME SPECIFIC STYLING
//----------------------------------------------------------------------------------

// Remove WooCommerce default styles
function thinkup_remove_woocommercestyles( $enqueue_styles ) {

	// Output custom styling
	unset( $enqueue_styles['woocommerce-general'] );
	unset( $enqueue_styles['woocommerce-layout'] );
	unset( $enqueue_styles['woocommerce-smallscreen'] );
	return $enqueue_styles;
}
add_filter( 'woocommerce_enqueue_styles', 'thinkup_remove_woocommercestyles' );

// Add theme specific WooCommerce default styles
function thinkup_input_woocommercestyles() {

	// Output custom styling
//	wp_enqueue_style( 'thinkup-woocommerce');
//	wp_enqueue_style( 'thinkup-woocommerce-theme');
}
add_action( 'wp_enqueue_scripts', 'thinkup_input_woocommercestyles', 11 );


//----------------------------------------------------------------------------------
//	SHOP PAGE (ARCHIVE PAGE) - STYLING
//----------------------------------------------------------------------------------

// Title of shop archive page - Used in intro and breadcrumbs
function thinkup_woo_titleshop_archive() {

	// Output custom styling
	$shop_page_id = wc_get_page_id( 'shop' );
	$page_title   = get_the_title( $shop_page_id );
	$page_title   = apply_filters( 'woocommerce_page_title', $page_title );
	return $page_title;
}

// Excerpt of shop archive page - Used in intro and breadcrumbs
function thinkup_woo_shop_excerpt() {

	// Output custom styling
	$shop_page_id = wc_get_page_id( 'shop' );
	$page_title   = get_the_excerpt( $shop_page_id );
	return $page_title;
}

// Return title for WC pages (i.e. account area)
function thinkup_woo_page_title() {

	// Output custom styling
	$shop_page_id = wc_get_page_id( 'shop' );
	$page_title   = get_the_excerpt( $shop_page_id );
	return $page_title;
}

// Return excerpt for WC pages (i.e. account area)
function thinkup_woo_page_excerpt() {

	// Assign default variable values
	$page_title = (string) null;

	// Get endpoint for current WC page
	$wc_endpoint = WC()->query->get_current_endpoint();

	// Change excerpt if logged in, otherwise work with logged out pages
	if (is_user_logged_in()) {

		// No endpoint - User is on dashbaord page
		if( empty ( $wc_endpoint ) ) {
			$page_title = 'Dashboard';
		} elseif( $wc_endpoint == 'api-downloads' ) {
			$page_title = 'Downloads';
		} elseif( $wc_endpoint == 'api-keys' ) {
			$page_title = 'API Keys';
		} elseif( $wc_endpoint == 'orders' ) {
			$page_title = 'Orders';
		} elseif( $wc_endpoint == 'subscriptions' ) {
			$page_title = 'Subscriptions';
		} elseif( $wc_endpoint == 'edit-address' ) {
			$page_title = 'Billing Address';
		} elseif( $wc_endpoint == 'edit-account' ) {
			$page_title = 'Account Details';
		}

	} else {

		// No endpoint - User is on login page
		if( empty ( $wc_endpoint ) ) {
			$page_title = 'Login to your account area';
		} elseif( $wc_endpoint == 'lost-password' ) {
			$page_title = 'Reset your account password';
		}
	}

	return $page_title;
}


//----------------------------------------------------------------------------------
//	CHECKOUT PAGE - CUSTOMIZATIONS
//----------------------------------------------------------------------------------

// Remove zeros after decimals from order decimal
add_filter( 'woocommerce_price_trim_zeros', '__return_true' );


//----------------------------------------------------------------------------------
//	ACCOUNT PAGE - STYLING
//----------------------------------------------------------------------------------

// Re-order Account pages menu
function thinkup_remove_my_account_links( $menu_links ){

	$items = array(
		'dashboard'       => 'Dashboard',
		'api-downloads'   => 'Downloads',
		'api-keys'        => 'API Keys',
		'orders'          => 'Orders',
//		'subscriptions'   => 'Subscriptions',
		'edit-address'    => 'Billing Address',
		'edit-account'    => 'Account Details',
		'customer-logout' => 'Logout',
	);

	// Check that pages exist in menu
	foreach($items as $key => $value ) {

		if( ! isset( $menu_links[$key] ) ) {
			unset( $items[$key] );
		}
	}

	return $items;
}
add_filter ( 'woocommerce_account_menu_items', 'thinkup_remove_my_account_links' );


//----------------------------------------------------------------------------------
//	SEND NEW USER EMAIL
//----------------------------------------------------------------------------------

// Send "New User Registration" email to admins when new customer is created on WooCommerce
function thinkup_woo_customer_created_notification( $id ) {
	wp_new_user_notification( $id, null, 'admin' );
}
add_action( 'woocommerce_created_customer', 'thinkup_woo_customer_created_notification' );


?>