<?php
/**
 * Theme setup functions.
 *
 * @package ThinkUpThemes
 */

/* ----------------------------------------------------------------------------------
	ADD LOGGED-IN / LOGGED-OUT CLASS TO BODY TAG
---------------------------------------------------------------------------------- */

// Add Logged In/Out class to <body> with WordPress
function tut_status_logged_class( $classes ) {

	if (is_user_logged_in()) {
		$classes[] = 'logged-in';
	} else {
		$classes[] = 'logged-out';
	}
	return $classes;
}
add_filter( 'body_class', 'tut_status_logged_class' );


/* ----------------------------------------------------------------------------------
	CORRECT Z-INDEX OF OEMBED OBJECTS
---------------------------------------------------------------------------------- */
function thinkup_fix_oembed( $embed ) {
	if ( strpos( $embed, '<param' ) !== false ) {
   		$embed = str_replace( '<embed', '<embed wmode="transparent" ', $embed );
   		$embed = preg_replace( '/param>/', 'param><param name="wmode" value="transparent" />', $embed, 1);
	}
	return $embed;
}
add_filter( 'embed_oembed_html', 'thinkup_fix_oembed', 1 );


/* ----------------------------------------------------------------------------------
	Intro Default options
---------------------------------------------------------------------------------- */

/* Add custom intro section [Extend for more options in future update] */
function thinkup_intro(
	string $intro_title = null,
	string $intro_excerpt = null
) {

	// Assign default variable values
	$output_title   = (string) null;
	$output_excerpt = (string) null;

	if ( ! is_front_page() ) {

		// Get intro title
		if( ! empty ( $intro_title ) ) {
			$output_title = '<h1 class="page-title">' . $intro_title . '</h1>';
		} else {
			$output_title = '<h1 class="page-title">' . thinkup_intro_title() . '</h1>';
		}

		// Get intro excerpt
		if( ! empty ( $intro_excerpt ) ) {
			$output_excerpt = '<p class="page-desc">' . $intro_excerpt . '</p>';
		} else {
			$output_excerpt = '<p class="page-desc">' . thinkup_intro_excerpt() . '</p>';
		}

		// Attach breackcrumbs to excerpt
//		$output_excerpt = $output_excerpt . thinkup_input_breadcrumb();

		// Output intro with breadcrumbs if set
		echo '<div id="intro" class="option1"><div id="intro-core">' . $output_title . $output_excerpt . '</div></div>';
	}

	// Hook to after content after intro (e.g. WooCommerce intro)
	do_action('thinkup_hook_custom_intro');
}


//----------------------------------------------------------------------------------
//	ADD PAGE TITLE
//----------------------------------------------------------------------------------

function thinkup_intro_title() {

	if ( is_page() ) {
		return sprintf( '<span>%s</span>', esc_html( get_the_title() ) );
	} elseif ( is_post_type_archive( 'product' ) and function_exists( 'thinkup_woo_titleshop_archive' ) ) {
		return thinkup_woo_titleshop_archive();
	} elseif ( is_archive() ) {
		return sprintf( get_the_archive_title() );
	} else {
		return sprintf( '<span>%s</span>', html_entity_decode( esc_html( get_the_title() ) ) );
	}
}

// Remove "archive" text from custom post type archive pages
function thinkup_intro_title_cpt($title) {
    if ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	}
	return $title;
};
add_filter( 'get_the_archive_title', 'thinkup_intro_title_cpt' );


//----------------------------------------------------------------------------------
//	Get archive text
//----------------------------------------------------------------------------------

function thinkup_intro_excerpt() {

	if ( is_page() ) {

		if ( class_exists( 'Woocommerce' ) ) {

			if( is_account_page() ) {
				return thinkup_woo_page_excerpt();
			} else {
				return sprintf( '<span>%s</span>', esc_html( get_the_excerpt() ) );
			}
		}

	} elseif ( is_post_type_archive( 'product' ) and function_exists( 'thinkup_woo_titleshop_archive' ) ) {
		return thinkup_woo_shop_excerpt();
	} elseif ( is_archive() ) {
		return sprintf( get_the_archive_title() );
	} else {
		return sprintf( '<span>%s</span>', html_entity_decode( esc_html( get_the_excerpt() ) ) );
	}
}


/* ----------------------------------------------------------------------------------
	Enable Breadcrumbs
---------------------------------------------------------------------------------- */

/* Toggle Breadcrumbs */
function thinkup_input_breadcrumb() {

	if( ! is_front_page() ) {
		thinkup_input_breadcrumb_html();
	}
}


/* ----------------------------------------------------------------------------------
	ADD BREADCRUMBS FUNCTIONALITY
---------------------------------------------------------------------------------- */

function thinkup_input_breadcrumb_html() {

	$delimiter = '<span class="delimiter">/</span>';

	$delimiter_inner   =   '<span class="delimiter_core"> &bull; </span>';
	$main              =   __( 'Home', 'minamaze' );
	$maxLength         =   30;

	/* Archive variables */
	$arc_year       =   get_the_time('Y');
	$arc_month      =   get_the_time('F');
	$arc_day        =   get_the_time('d');
	$arc_day_full   =   get_the_time('l');

	/* URL variables */
	$url_year    =   get_year_link($arc_year);
	$url_month   =   get_month_link($arc_year,$arc_month);

	/* Display breadcumbs if NOT the home page */
	if ( ! is_front_page() ) {
		echo '<div id="breadcrumbs"><div id="breadcrumbs-core">';
		global $post, $cat;
		$homeLink = home_url( '/' );
		echo '<a href="' . esc_url( $homeLink ) . '">' . esc_html( $main ) . '</a>' . $delimiter;

		/* Display breadcrumbs for single post */
		if ( is_single() ) {
			$category = get_the_category();
			$num_cat = count($category);
			if ($num_cat <=1) {
				echo ' ' . esc_html( get_the_title() );
			} else {

				// Count Total categories
				foreach( get_the_category() as $category) {
					$count_categories++;
				}

				// Output Categories
				foreach( get_the_category() as $category) {
					$count_loop++;

					if ( $count_loop < $count_categories ) {
						echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->cat_name ) . '</a>' . $delimiter_inner;
					} else {
						echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->cat_name ) . '</a>';
					}
				}

				if (strlen(get_the_title()) >= $maxLength) {
					echo ' ' . $delimiter . esc_html( trim( substr( get_the_title(), 0, $maxLength ) ) ) . ' &hellip;';
				} else {
					echo ' ' . $delimiter . esc_html( get_the_title() );
				}
			}
		} elseif (is_category()) {
			_e( 'Archive Category: ', 'minamaze' ) . get_category_parents($cat, true,' ' . $delimiter . ' ') ;
		} elseif ( is_tag() ) {
			_e( 'Posts Tagged: ', 'minamaze' ) . single_tag_title("", false) . '"';
		} elseif ( is_day()) {
			echo '<a href="' . $url_year . '">' . $arc_year . '</a> ' . $delimiter . ' ';
			echo '<a href="' . $url_month . '">' . $arc_month . '</a> ' . $delimiter . $arc_day . ' (' . $arc_day_full . ')';
		} elseif ( is_month() ) {
			echo '<a href="' . $url_year . '">' . $arc_year . '</a> ' . $delimiter . $arc_month;
		} elseif ( is_year() ) {
			echo $arc_year;
		} elseif ( is_search() ) {
			_e( 'Search Results for: ', 'minamaze' ) . esc_html( get_search_query() ) . '"';
		} elseif ( is_page() && !$post->post_parent ) {
			echo esc_html( get_the_title() );
		} elseif ( is_page() && $post->post_parent ) {
			$post_array = get_post_ancestors( $post );
			krsort( $post_array );
			foreach( $post_array as $key=>$postid ){
				$post_ids = get_post( $postid );
				$title = $post_ids->post_title;
				echo '<a href="' . esc_url( get_permalink( $post_ids ) ) . '">' . esc_html( $title ) . '</a>' . $delimiter;
			}
			the_title();
		} elseif ( is_author() ) {
			global $author;
			$user_info = get_userdata($author);
			_e( 'Archived Article(s) by Author: ', 'minamaze' ) . esc_html( $user_info->display_name );
		} elseif ( is_404() ) {
			_e( 'Error 404 - Not Found.', 'minamaze' );
		} elseif ( is_post_type_archive( 'portfolio' )	) {
			_e( 'Portfolio', 'minamaze' );
		} elseif ( is_post_type_archive( 'product' ) and function_exists( 'thinkup_woo_titleshop_archive' ) ) {
			thinkup_woo_titleshop_archive();
		} elseif ( is_archive() ) {
			echo get_the_archive_title();
		} elseif( is_tax() ) {
			echo esc_html( get_queried_object()->name );
		} elseif ( thinkup_check_isblog() ) {
			_e( 'Blog', 'minamaze' );
		} else {
			echo html_entity_decode( esc_html( get_the_title() ) );
		}

		echo '</div></div>';
    }
}


/* ----------------------------------------------------------------------------------
	ADD CUSTOM FEATURED IMAGE SIZES
---------------------------------------------------------------------------------- */

if ( ! function_exists( 'thinkup_input_addimagesizes' ) ) {
	function thinkup_input_addimagesizes() {

		/* Legacy - 1 Column Layout */
		add_image_size( 'legacy-column1-1/3', 960, 320, true );

		/* 1 Column Layout */
//		add_image_size( 'column1-1/1', 1140, 1140, true );
		add_image_size( 'column1-1/2', 1140, 570, true );
		add_image_size( 'column1-1/3', 1140, 380, true );
//		add_image_size( 'column1-2/3', 1140, 760, true );
		add_image_size( 'column1-1/4', 1140, 285, true );
//		add_image_size( 'column1-3/4', 1140, 855, true );
//		add_image_size( 'column1-1/5', 1140, 228, true );
		add_image_size( 'column1-2/5', 1140, 456, true );
//		add_image_size( 'column1-3/5', 1140, 684, true );
//		add_image_size( 'column1-4/5', 1140, 912, true );

		/* 2 Column Layout */
//		add_image_size( 'column2-1/1', 570, 570, true );
//		add_image_size( 'column2-1/2', 570, 285, true );
//		add_image_size( 'column2-1/3', 570, 190, true );
//		add_image_size( 'column2-2/3', 570, 380, true );
//		add_image_size( 'column2-1/4', 570, 143, true );
//		add_image_size( 'column2-3/4', 570, 428, true );
//		add_image_size( 'column2-1/5', 570, 114, true );
//		add_image_size( 'column2-2/5', 570, 228, true );
//		add_image_size( 'column2-3/5', 570, 342, true );
//		add_image_size( 'column2-4/5', 570, 456, true );

		/* 3 Column Layout */
//		add_image_size( 'column3-1/1', 380, 380, true );
//		add_image_size( 'column3-1/2', 380, 190, true );
//		add_image_size( 'column3-1/3', 380, 127, true );
//		add_image_size( 'column3-2/3', 380, 254, true );
//		add_image_size( 'column3-1/4', 380, 95, true );
//		add_image_size( 'column3-3/4', 380, 285, true );
//		add_image_size( 'column3-1/5', 380, 76, true );
//		add_image_size( 'column3-2/5', 380, 152, true );
//		add_image_size( 'column3-3/5', 380, 228, true );
//		add_image_size( 'column3-4/5', 380, 304, true );

		/* 4 Column Layout */
//		add_image_size( 'column4-1/1', 285, 285, true );
//		add_image_size( 'column4-1/2', 285, 143, true );
//		add_image_size( 'column4-1/3', 285, 95, true );
//		add_image_size( 'column4-2/3', 285, 190, true );
//		add_image_size( 'column4-1/4', 285, 72, true );
//		add_image_size( 'column4-3/4', 285, 214, true );
//		add_image_size( 'column4-1/5', 285, 57, true );
//		add_image_size( 'column4-2/5', 285, 114, true );
//		add_image_size( 'column4-3/5', 285, 171, true );
//		add_image_size( 'column4-4/5', 285, 228, true );
	}
	add_action( 'after_setup_theme', 'thinkup_input_addimagesizes' );
}

if ( ! function_exists( 'thinkup_input_showimagesizes' ) ) {
	function thinkup_input_showimagesizes($sizes) {

		/* 1 Column Layout */
//		$sizes['column1-1/1'] = __( 'Full - 1:1', 'minamaze' );
		$sizes['column1-1/2'] = __( 'Full - 1:2', 'minamaze' );
		$sizes['column1-1/3'] = __( 'Full - 1:3', 'minamaze' );
//		$sizes['column1-2/3'] = __( 'Full - 2:3', 'minamaze' );
		$sizes['column1-1/4'] = __( 'Full - 1:4', 'minamaze' );
//		$sizes['column1-3/4'] = __( 'Full - 3:4', 'minamaze' );
//		$sizes['column1-1/5'] = __( 'Full - 1:5', 'minamaze' );
		$sizes['column1-2/5'] = __( 'Full - 2:5', 'minamaze' );
//		$sizes['column1-3/5'] = __( 'Full - 3:5', 'minamaze' );
//		$sizes['column1-4/5'] = __( 'Full - 4:5', 'minamaze' );

		/* 2 Column Layout */
//		$sizes['column2-1/1'] = __( 'Half - 1:1', 'minamaze' );
//		$sizes['column2-1/2'] = __( 'Half - 1:2', 'minamaze' );
//		$sizes['column2-1/3'] = __( 'Half - 1:3', 'minamaze' );
//		$sizes['column2-2/3'] = __( 'Half - 2:3', 'minamaze' );
//		$sizes['column2-1/4'] = __( 'Half - 1:4', 'minamaze' );
//		$sizes['column2-3/4'] = __( 'Half - 3:4', 'minamaze' );
//		$sizes['column2-1/5'] = __( 'Half - 1:5', 'minamaze' );
//		$sizes['column2-2/5'] = __( 'Half - 2:5', 'minamaze' );
//		$sizes['column2-3/5'] = __( 'Half - 3:5', 'minamaze' );
//		$sizes['column2-4/5'] = __( 'Half - 4:5', 'minamaze' );

		/* 3 Column Layout */
//		$sizes['column3-1/1'] = __( 'Third - 1:1', 'minamaze' );
//		$sizes['column3-1/2'] = __( 'Third - 1:2', 'minamaze' );
//		$sizes['column3-1/3'] = __( 'Third - 1:3', 'minamaze' );
//		$sizes['column3-2/3'] = __( 'Third - 2:3', 'minamaze' );
//		$sizes['column3-1/4'] = __( 'Third - 1:4', 'minamaze' );
//		$sizes['column3-3/4'] = __( 'Third - 3:4', 'minamaze' );
//		$sizes['column3-1/5'] = __( 'Third - 1:5', 'minamaze' );
//		$sizes['column3-2/5'] = __( 'Third - 2:5', 'minamaze' );
//		$sizes['column3-3/5'] = __( 'Third - 3:5', 'minamaze' );
//		$sizes['column3-4/5'] = __( 'Third - 4:5', 'minamaze' );

		/* 4 Column Layout */
//		$sizes['column4-1/1'] = __( 'Quarter - 1:1', 'minamaze' );
//		$sizes['column4-1/2'] = __( 'Quarter - 1:2', 'minamaze' );
//		$sizes['column4-1/3'] = __( 'Quarter - 1:3', 'minamaze' );
//		$sizes['column4-2/3'] = __( 'Quarter - 2:3', 'minamaze' );
//		$sizes['column4-1/4'] = __( 'Quarter - 1:4', 'minamaze' );
//		$sizes['column4-3/4'] = __( 'Quarter - 3:4', 'minamaze' );
//		$sizes['column4-1/5'] = __( 'Quarter - 1:5', 'minamaze' );
//		$sizes['column4-2/5'] = __( 'Quarter - 2:5', 'minamaze' );
//		$sizes['column4-3/5'] = __( 'Quarter - 3:5', 'minamaze' );
//		$sizes['column4-4/5'] = __( 'Quarter - 4:5', 'minamaze' );

		return $sizes;
	}
	add_filter('image_size_names_choose', 'thinkup_input_showimagesizes');
}


/* ----------------------------------------------------------------------------------
	ADD HOME: HOME TO CUSTOM MENU PAGE LIST
---------------------------------------------------------------------------------- */

function thinkup_menu_homelink( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'thinkup_menu_homelink' );


//----------------------------------------------------------------------------------
//	ADD FUNCTION TO GET CURRENT PAGE URL
//----------------------------------------------------------------------------------

function thinkup_check_currentpage() {
	$pageURL = 'http';
	if( isset($_SERVER["HTTPS"]) ) {
		if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	}
	$pageURL .= '://' . wp_unslash( $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"] );

	$pageURL    = rtrim($pageURL, '/') . '/';
	$currentURL = get_permalink();

	// Add www. to current page url if present in permalink
	if (strpos( $currentURL, 'www.' ) !== false) {
		if (strpos( $pageURL, '://www.' ) !== false) {
			$pageURL = $pageURL;
		} else {
			$pageURL = str_replace( "://", "://www.", $pageURL );
		}
	} else {
		$pageURL = str_replace( "www.", "", $pageURL );
	}

	// Add trailing slash "/" at end of link if present in permalink
	if ( substr( $currentURL, -1 ) == '/' ) {
		$pageURL = trailingslashit( $pageURL );
	} else {
		$pageURL = untrailingslashit( $pageURL );
	}

	// Add correct http: or https: prefix to current page url
	if (strpos( $currentURL, 'http://' ) !== false) {
		$pageURL = str_replace( "https://", "http://", $pageURL );
	} else {
		$pageURL = str_replace( "http://", "https://", $pageURL );
	}

	return $pageURL;
}


//----------------------------------------------------------------------------------
//	ADD CUSTOM COMMENTS POP UP LINK FUNCTION - Credit to http://www.thescubageek.com/code/wordpress-code/add-get_comments_popup_link-to-wordpress/
//----------------------------------------------------------------------------------

// Modifies WordPress's built-in comments_popup_link() function to return a string instead of echo comment results
function thinkup_input_commentspopuplink( $zero = false, $one = false, $more = false, $css_class = '', $none = false ) {
    global $wpcommentspopupfile, $wpcommentsjavascript;

    $id = get_the_ID();

    if ( false === $zero ) $zero = __( 'No Comments','minamaze' );
    if ( false === $one ) $one = __( '1 Comment','minamaze' );
    if ( false === $more ) $more = __( '% Comments','minamaze' );
    if ( false === $none ) $none = __( 'Comments Off','minamaze' );

    $number = get_comments_number( $id );

    $str = '';

    if ( 0 == $number && !comments_open() && !pings_open() ) {
        $str = '<span' . ((!empty($css_class)) ? ' class="' . esc_attr( $css_class ) . '"' : '') . '>' . $none . '</span>';
        return $str;
    }

    if ( post_password_required() ) {
        $str = __('Enter your password to view comments.','minamaze');
        return $str;
    }

    $str = '<a href="';
    if ( $wpcommentsjavascript ) {
        if ( empty( $wpcommentspopupfile ) )
            $home = home_url();
        else
            $home = get_option('siteurl');
        $str .= $home . '/' . $wpcommentspopupfile . '?comments_popup=' . $id;
        $str .= '" onclick="wpopen(this.href); return false"';
    } else { // if comments_popup_script() is not in the template, display simple comment link
        if ( 0 == $number )
            $str .= get_permalink() . '#respond';
        else
            $str .= get_comments_link();
        $str .= '"';
    }

    if ( !empty( $css_class ) ) {
        $str .= ' class="'.$css_class.'" ';
    }
    $title = the_title_attribute( array('echo' => 0 ) );

    $str .= apply_filters( 'comments_popup_link_attributes', '' );

    $str .= ' title="' . esc_attr( sprintf( __('Comment on %s','minamaze'), $title ) ) . '">';
    $str .= thinkup_comments_returnstring( $zero, $one, $more );
    $str .= '</a>';

    return $str;
}

// Modifies WordPress's built-in comments_number() function to return string instead of echo
function thinkup_comments_returnstring( $zero = false, $one = false, $more = false, $deprecated = '' ) {
    if ( !empty( $deprecated ) )
        _deprecated_argument( __FUNCTION__, '1.3' );

    $number = get_comments_number();

    if ( $number > 1 )
        $output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __( '% Comments', 'minamaze' ) : $more);
    elseif ( $number == 0 )
        $output = ( false === $zero ) ? __( 'No Comments', 'minamaze' ) : $zero;
    else // must be one
        $output = ( false === $one ) ? __( '1 Comment', 'minamaze' ) : $one;

    return apply_filters('comments_number', $output, $number);
}


//----------------------------------------------------------------------------------
//	CHANGE FALLBACK WP_PAGE_MENU CLASSES TO MATCH WP_NAV_MENU CLASSES
//----------------------------------------------------------------------------------

function thinkup_input_menuclass( $ulclass ) {

	// Add menu class to list
	$ulclass = preg_replace( '/<ul>/', '<ul class="menu">', $ulclass, 1 );
	$ulclass = str_replace( 'children', 'sub-menu', $ulclass );

	// Remove div wrapper
	$ulclass = str_replace( '<div class="menu">', '', $ulclass );
	$ulclass = str_replace( '</div>', '', $ulclass );

	return preg_replace('/<div (.*)>(.*)<\/div>/iU', '$2', $ulclass );
}
add_filter( 'wp_page_menu', 'thinkup_input_menuclass' );


//----------------------------------------------------------------------------------
//	DETERMINE IF THE PAGE IS A BLOG - USEFUL FOR HOMEPAGE BLOG.
//----------------------------------------------------------------------------------

// Credit to: http://www.poseidonwebstudios.com/web-development/wordpress-is_blog-function/
function thinkup_check_isblog() {

    global $post;

    //Post type must be 'post'.
    $post_type = get_post_type($post);

    //Check all blog-related conditional tags, as well as the current post type,
    //to determine if we're viewing a blog page.
    return (
        ( is_home() || is_archive() )
        && ($post_type == 'post')
    ) ? true : false ;

}


//----------------------------------------------------------------------------------
//	ADD TAGS AND CATEGORIES TO PAGES.
//----------------------------------------------------------------------------------

// Register taxonomies for pages
function thinkup_taxonomy_pages() {
	register_taxonomy_for_object_type( 'post_tag', 'page' );
	register_taxonomy_for_object_type( 'category', 'page' );
}
if ( ! is_admin() ) {
	add_action( 'pre_get_posts', 'thinkup_archives_category' );
	add_action( 'pre_get_posts', 'thinkup_archives_tags' );
}

// Add categories to pages
function thinkup_archives_category( $wp_query ) {
	if ( $wp_query->get( 'category_name' ) || $wp_query->get( 'cat' ) )
	$wp_query->set( 'post_type', 'any' );
}

// Add tags to pages
function thinkup_archives_tags( $wp_query ) {
	if ( $wp_query->get( 'tag' ) )
		$wp_query->set( 'post_type', 'any' );
}
add_action( 'init', 'thinkup_taxonomy_pages' );


//----------------------------------------------------------------------------------
//	CONVERT HEX COLORS TO RGB.
//----------------------------------------------------------------------------------

function thinkup_convert_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   //return implode(",", $rgb); // returns the rgb values separated by commas
   return $rgb; // returns an array with the rgb values
}


//----------------------------------------------------------------------------------
//	ADD FEATURED IMAGE THUMBNAIL.
//----------------------------------------------------------------------------------

// Add featured images to posts
add_filter('manage_pages_columns', 'thinkup_posts_columns', 5);
add_filter('manage_posts_columns', 'thinkup_posts_columns', 5);
add_action('manage_posts_custom_column', 'thinkup_posts_custom_columns', 5, 2);
add_action('manage_pages_custom_column', 'thinkup_posts_custom_columns', 5, 2);
function thinkup_posts_columns($defaults){
    $defaults['riv_post_thumbs'] = __( 'Thumbs', 'minamaze' );
    return $defaults;
}
function thinkup_posts_custom_columns($column_name, $id){
        if($column_name === 'riv_post_thumbs'){
        echo the_post_thumbnail( 'thumbnail' );
    }
}


//----------------------------------------------------------------------------------
//	GET EXCERPT BY ID.
//----------------------------------------------------------------------------------

function thinkup_input_excerptbyid( $post_id, $except_count = 55 ) {
	$the_post = get_post( $post_id );

	// Get post excerpt
	$the_excerpt = $the_post->post_excerpt;

	// Get post content if no excerp set
	if ( empty( $the_excerpt ) ) {
		$the_excerpt = $the_post->post_content;
	}

	//Sets excerpt length by word count
	$excerpt_length = $except_count;

	 //Strips tags and images
	$the_excerpt = strip_tags( strip_shortcodes( $the_excerpt ) );
	$words = explode( ' ', $the_excerpt, $excerpt_length + 1 );

	if( count( $words ) > $excerpt_length ) {
		array_pop( $words );
		array_push( $words, '…' );
		$the_excerpt = implode( ' ', $words );
	}

	if ( ! empty( $the_excerpt ) ) {
		$the_excerpt = '<p>' . $the_excerpt . '</p>';
	}
	return $the_excerpt;
}


//----------------------------------------------------------------------------------
//	ADD MORE BUTTONS TO VISUAL EDITOR.
//----------------------------------------------------------------------------------

function thinkup_visualeditor_morebuttons($buttons) {
	$buttons[] = 'hr';
	$buttons[] = 'del';
	$buttons[] = 'sub';
	$buttons[] = 'sup';
	$buttons[] = 'fontselect';
	$buttons[] = 'fontsizeselect';
	$buttons[] = 'cleanup';
	$buttons[] = 'styleselect';

	return $buttons;
}
add_filter( 'mce_buttons_3', 'thinkup_visualeditor_morebuttons' );


//----------------------------------------------------------------------------------
//	ADD GOOGLE FONT - RALEWAY & OPEN SANS. (http://themeshaper.com/2014/08/13/how-to-add-google-fonts-to-wordpress-themes/)
//----------------------------------------------------------------------------------

function thinkup_googlefonts_url() {
    $fonts_url = '';

    // Translators: Translate this to 'off' if there are characters in your language that are not supported by Open Sans
    $font_translate = _x( 'on', 'Raleway font: on or off', 'minamaze' );

    if ( 'off' !== $font_translate ) {
        $font_families = array();

        if ( 'off' !== $font_translate ) {
            $font_families[] = 'Raleway:300,400,600,700';
            $font_families[] = 'Open Sans:300,400,600,700';
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return $fonts_url;
}

function thinkup_googlefonts_scripts() {
//   wp_enqueue_style( 'thinkup-google-fonts', thinkup_googlefonts_url(), array(), null );
}
//add_action( 'wp_enqueue_scripts', 'thinkup_googlefonts_scripts' );


//----------------------------------------------------------------------------------
//	FIX JETPACK PHOTON IMAGE LOAD ISSUE - DISABLE CACHING FOR SPECIFIC IMAGES
//----------------------------------------------------------------------------------

function thinkup_photon_exception( $val, $src, $tag ) {
        if ( $src == get_template_directory_uri() . '/images/transparent.png' ) {
                return true;
        }
        return $val;
}
add_filter( 'jetpack_photon_skip_image', 'thinkup_photon_exception', 10, 3 );


//----------------------------------------------------------------------------------
//	CUSTOM FUNCTION TO CHECK IF USER IS ON THE LOGIN PAGE
//----------------------------------------------------------------------------------

if ( ! function_exists( 'thinkup_is_login_page' ) ) {
	function thinkup_is_login_page() {
		return in_array( $GLOBALS['pagenow'], array( 'wp-login.php', 'wp-register.php' ) );
	}
}


//----------------------------------------------------------------------------------
//	CUSTOM FUNCTION TO GET IMAGE SIZES
//----------------------------------------------------------------------------------

function thinkup_get_image_sizes() {
	global $_wp_additional_image_sizes;

	$sizes = array();

	foreach ( get_intermediate_image_sizes() as $_size ) {
		if ( in_array( $_size, array('thumbnail', 'medium', 'medium_large', 'large') ) ) {
			$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
			$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
			$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
		} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
			$sizes[ $_size ] = array(
				'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
				'height' => $_wp_additional_image_sizes[ $_size ]['height'],
				'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
			);
		}
	}

	return $sizes;
}

function thinkup_get_image_size( $size ) {
	$sizes = thinkup_get_image_sizes();

	if ( isset( $sizes[ $size ] ) ) {
		return $sizes[ $size ];
	}

	return false;
}


//----------------------------------------------------------------------------------
//	REMOVE ALL CUSTOM TUT METABOXES FROM GUTENBERG PAGES
//----------------------------------------------------------------------------------

function thinkup_disable_panels_for_gutenberg_posts( $wp_meta_boxes ) {

	// Loop through all meta box combinations to find TUT meta boxes and remove
	foreach ( $wp_meta_boxes as &$locations ) {
		foreach ( $locations as &$priorities ) {
			foreach ( $priorities as &$boxes ) {
				foreach ( $boxes as $box_key => $box_value ) {

					// Remove all TUT meta box
					if ( strpos( $box_key, 'thinkup' ) !== false ) {
						unset( $boxes[$box_key] );
					}

				}
			}
		}
	}
	return $wp_meta_boxes;
}
add_filter( 'filter_gutenberg_meta_boxes', 'thinkup_disable_panels_for_gutenberg_posts' );


// ====================================================================================================
// Allows Array to be sorted in a specific order (e.g. date, alphabetical, etc...)
// ====================================================================================================

function thinkup_array_sort($array, $on, $order=SORT_ASC){

    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
                break;
            case SORT_DESC:
                arsort($sortable_array);
                break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}


// ====================================================================================================
// Display User IP in WordPress 
// ====================================================================================================

function thinkup_get_user_ip() { 

	if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) { 
		$ip = $_SERVER['HTTP_CLIENT_IP']; 
	 }
	 
	 elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR']; 
	 }
	 
	 else { 
		 $ip = $_SERVER['REMOTE_ADDR']; 
	 } 
	 
	 return $ip; 
}