<?php
/**
 * Plugin Name: WP Rocket | No LazyLoad
 * Description: Disables LazyLoad for specified page types.
 * Plugin URI:  https://github.com/wp-media/wp-rocket-helpers/tree/master/lazyload/wp-rocket-no-lazyload/
 * Author:      WP Rocket Support Team
 * Author URI:  http://wp-rocket.me/
 * License:     GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright SAS WP MEDIA 2018
 */

// Standard plugin security, keep this line in place.
defined( 'ABSPATH' ) or die();

/**
 * Disable LazyLoad on single post views.
 *
 * @author Caspar Hübinger
 */
function thinkup_wpr_deactivate_lazyload_on_product() {

	// Disable LazyLoad for images on a 'post' post type singular template.
	if( is_singular( 'product' ) or is_singular( 'free' ) ) {
		add_filter( 'do_rocket_lazyload', '__return_false' );
	}
}
add_filter( 'wp', 'thinkup_wpr_deactivate_lazyload_on_product' );
