<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              sarka.com
 * @since             1.0.0
 * @package           Sarka
 *
 * @wordpress-plugin
 * Plugin Name:       Sarka | Blog Monitor
 * Plugin URI:        Sarka
 * Description:       Internal Tool - Use this to keep posts updated regularly across Sarka Insights Ltd companies.
 * Version:           1.0.0
 * Author:            Sarka
 * Author URI:        sarka.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       sarka
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define global variables
 */
define( 'SARKA_VERSION', '1.0.0' );
define( 'SARKA_PLUGIN_FILE', plugin_basename(__FILE__) );
define( 'SARKA_PLUGIN_SETTINGS_URL', 'admin.php?page=sarka_blog_monitor' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sarka-activator.php
 */
function activate_sarka() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sarka-activator.php';
	Sarka_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sarka-deactivator.php
 */
function deactivate_sarka() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sarka-deactivator.php';
	Sarka_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_sarka' );
register_deactivation_hook( __FILE__, 'deactivate_sarka' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-sarka.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function run_sarka() {

	$plugin = new Sarka();
	$plugin->run();

}
run_sarka();
